/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ProjectSchemeAssociationManager {
    private final SchemeManagerFactory schemeManagerFactory;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final FieldManager fieldManager;
    private final ProjectManager projectManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final PrioritySchemeManager prioritySchemeManager;

    public ProjectSchemeAssociationManager(SchemeManagerFactory schemeManagerFactory, IssueTypeSchemeManager issueTypeSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldConfigSchemeManager fieldConfigSchemeManager, FieldManager fieldManager, ProjectManager projectManager, FieldLayoutManager fieldLayoutManager, PrioritySchemeManager prioritySchemeManager) {
        this.schemeManagerFactory = schemeManagerFactory;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.fieldManager = fieldManager;
        this.projectManager = projectManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.prioritySchemeManager = prioritySchemeManager;
    }

    void associateDefaultSchemesWithProject(Project newProject) {
        for (SchemeManager schemeManager : this.schemeManagerFactory.getAllSchemeManagers()) {
            schemeManager.addDefaultSchemeToProject(newProject);
        }
        this.issueTypeScreenSchemeManager.associateWithDefaultScheme(newProject);
    }

    void associateSchemesOfExistingProjectWithNewProject(Project newProject, Project existingProject) {
        for (SchemeManager schemeManager : this.schemeManagerFactory.getAllSchemeManagers()) {
            Optional<Scheme> projectScheme = Optional.ofNullable(schemeManager.getSchemeFor(existingProject));
            projectScheme.ifPresent(scheme -> schemeManager.addSchemeToProject(newProject, scheme));
        }
        this.associateIssueTypeScheme(newProject, existingProject);
        Optional<IssueTypeScreenScheme> optionalIssueTypeScreenScheme = Optional.ofNullable(this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(existingProject));
        optionalIssueTypeScreenScheme.ifPresent(scheme -> this.issueTypeScreenSchemeManager.addSchemeAssociation(newProject, scheme));
        Optional<FieldConfigurationScheme> optionalFieldConfigScheme = Optional.ofNullable(this.fieldLayoutManager.getFieldConfigurationScheme(existingProject));
        optionalFieldConfigScheme.ifPresent(scheme -> this.fieldLayoutManager.addSchemeAssociation(newProject, scheme.getId()));
        Optional.ofNullable(this.prioritySchemeManager.getScheme(existingProject)).filter(scheme -> !this.prioritySchemeManager.isDefaultScheme(scheme)).ifPresent(scheme -> this.prioritySchemeManager.assignProject(scheme, newProject));
    }

    private void associateIssueTypeScheme(Project newProject, Project existingProject) {
        Optional<FieldConfigScheme> fieldConfigScheme = Optional.ofNullable(this.issueTypeSchemeManager.getConfigScheme(existingProject));
        fieldConfigScheme.filter(scheme -> !this.issueTypeSchemeManager.isDefaultIssueTypeScheme(scheme)).ifPresent(scheme -> {
            ArrayList projectIds = Lists.newArrayList((Iterable)scheme.getAssociatedProjectIds());
            projectIds.add(newProject.getId());
            List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)false, (Long[])((Long[])projectIds.stream().toArray(Long[]::new)), (ProjectManager)this.projectManager);
            this.fieldConfigSchemeManager.updateFieldConfigScheme(scheme, contexts, this.fieldManager.getConfigurableField("issuetype"));
            this.fieldManager.refresh();
        });
    }
}

