/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ComponentConverter;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.model.querydsl.QComponent;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizProjectComponentStore
implements ProjectComponentStore {
    public static final Logger log = Logger.getLogger(ProjectComponentStore.class);
    private final OfBizDelegator delegator;
    private final DbConnectionManager dbConnectionManager;
    static final String FIELD_ID = "id";
    static final String FIELD_NAME = "name";
    static final String FIELD_DESCRIPTION = "description";
    static final String FIELD_LEAD = "lead";
    static final String FIELD_PROJECT = "project";
    static final String FIELD_ASSIGNEE_TYPE = "assigneetype";
    static final String FIELD_ARCHIVED = "archived";

    public OfBizProjectComponentStore(OfBizDelegator delegator, DbConnectionManager dbConnectionManager) {
        this.delegator = delegator;
        this.dbConnectionManager = dbConnectionManager;
    }

    @Override
    public MutableProjectComponent find(Long id) throws EntityNotFoundException {
        this.validateId(id);
        GenericValue componentGV = this.findComponentGV(FIELD_ID, id);
        if (componentGV == null) {
            throw new EntityNotFoundException("Component with ID = '" + id + "' does not exist.");
        }
        return this.getComponentConverter().convertToComponent(componentGV);
    }

    @Override
    public ProjectComponent getProjectComponent(Long projectComponentId) {
        this.validateId(projectComponentId);
        GenericValue gv = this.findComponentGV(FIELD_ID, projectComponentId);
        if (gv == null) {
            return null;
        }
        return Entity.PROJECT_COMPONENT.build(gv);
    }

    @Override
    public Collection<MutableProjectComponent> findAllForProject(Long projectId) {
        return this.getComponentConverter().convertToComponents(this.findComponentGVs(FIELD_PROJECT, projectId, FIELD_NAME));
    }

    protected ComponentConverter getComponentConverter() {
        return new ComponentConverter();
    }

    @Override
    public MutableProjectComponent findByComponentName(Long projectId, String componentName) throws IllegalArgumentException {
        if (projectId == null) {
            throw new IllegalArgumentException("Project ID is required, was null.");
        }
        if (componentName == null) {
            throw new IllegalArgumentException("Component Name is required, was null.");
        }
        List components = this.delegator.findByAnd("Component", MapBuilder.newBuilder().add((Object)FIELD_PROJECT, (Object)projectId).add((Object)FIELD_NAME, (Object)componentName).toMap());
        if (components.size() == 1) {
            return this.getComponentConverter().convertToComponent((GenericValue)components.get(0));
        }
        if (components.size() == 0) {
            return null;
        }
        log.error((Object)("found " + components.size() + " components with name " + componentName + " in project with id " + projectId));
        return (MutableProjectComponent)components.get(0);
    }

    @Override
    public Collection<MutableProjectComponent> findByComponentNameCaseInSensitive(String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException("Component Name is required, was null.");
        }
        Collection<MutableProjectComponent> components = this.getComponentConverter().convertToComponents(this.delegator.findAll("Component"));
        ArrayList<MutableProjectComponent> matched = new ArrayList<MutableProjectComponent>();
        for (MutableProjectComponent component : components) {
            if (!componentName.equalsIgnoreCase(component.getName())) continue;
            matched.add(component);
        }
        return matched;
    }

    @Override
    public Long findProjectIdForComponent(Long componentId) throws EntityNotFoundException {
        GenericValue componentGV = this.findComponentGV(FIELD_ID, componentId);
        if (componentGV == null) {
            throw new EntityNotFoundException("Component with ID = '" + componentId + "' does not exist.");
        }
        return componentGV.getLong(FIELD_PROJECT);
    }

    @Override
    public MutableProjectComponent store(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        this.validateProjectId(component);
        this.validateName(component);
        Long id = component.getId();
        if (id == null) {
            String name = component.getName();
            HashMap<String, Object> componentParams = new HashMap<String, Object>();
            componentParams.put(FIELD_NAME, name);
            componentParams.put(FIELD_DESCRIPTION, component.getDescription());
            componentParams.put(FIELD_LEAD, component.getLead());
            componentParams.put(FIELD_PROJECT, component.getProjectId());
            componentParams.put(FIELD_ASSIGNEE_TYPE, component.getAssigneeType());
            componentParams.put(FIELD_ARCHIVED, component.isArchived());
            GenericValue componentGV = this.delegator.createValue("Component", componentParams);
            component.setId(componentGV.getLong(FIELD_ID));
            component.setGenericValue(componentGV);
        } else {
            if (this.findComponentGV(FIELD_ID, component.getId()) == null) {
                throw new EntityNotFoundException("Component with ID = '" + id + "' does not exist.");
            }
            GenericValue componentGV = component.getGenericValue();
            if (componentGV == null) {
                throw new EntityNotFoundException("Component with ID = '" + id + "' does not exist.");
            }
            componentGV.setString(FIELD_NAME, component.getName());
            componentGV.setString(FIELD_DESCRIPTION, component.getDescription());
            componentGV.setString(FIELD_LEAD, component.getLead());
            componentGV.set(FIELD_ASSIGNEE_TYPE, (Object)component.getAssigneeType());
            componentGV.set(FIELD_ARCHIVED, (Object)component.isArchived());
            try {
                componentGV.store();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Unable to update the component with ID = '" + id + "'.", (Throwable)e);
            }
        }
        return MutableProjectComponent.copy((ProjectComponent)component);
    }

    private void validateName(MutableProjectComponent component) throws IllegalArgumentException {
        if (component.getName() == null) {
            throw new IllegalArgumentException("Name is required, was null.");
        }
    }

    private void validateProjectId(MutableProjectComponent component) throws IllegalArgumentException {
        if (component.getProjectId() == null) {
            throw new IllegalArgumentException("Project ID is required, was null.");
        }
    }

    private void validateId(Long id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("Project Component ID is required, was null.");
        }
    }

    @Override
    public void delete(Long componentId) throws EntityNotFoundException {
        int deleted = this.delegator.removeByAnd("Component", MapBuilder.build((Object)FIELD_ID, (Object)componentId));
        if (deleted == 0) {
            throw new EntityNotFoundException("Unable to find the component with ID = '" + componentId + "' for deletion.");
        }
    }

    @Override
    public void deleteAllComponents(@Nonnull Long projectId) {
        this.dbConnectionManager.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)QComponent.COMPONENT).where((Predicate)QComponent.COMPONENT.project.eq((Object)projectId)).execute());
    }

    @Override
    public boolean containsName(String name, Long projectId) {
        if (projectId == null) {
            throw new IllegalArgumentException("Component project ID can not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Component name can not be null!");
        }
        List<GenericValue> componentsForProject = this.findComponentGVs(FIELD_PROJECT, projectId);
        for (GenericValue componentGV : componentsForProject) {
            if (!name.equalsIgnoreCase(componentGV.getString(FIELD_NAME))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection findComponentsBylead(String userKey) {
        return this.getComponentConverter().convertToComponents(this.findComponentGVs(FIELD_LEAD, userKey));
    }

    @Override
    public Collection findAll() {
        return this.getComponentConverter().convertToComponents(this.delegator.findAll("Component", CollectionBuilder.list((Object[])new String[]{FIELD_NAME})));
    }

    private GenericValue findComponentGV(String fieldName, Object fieldValue) {
        return EntityUtil.getOnly(this.findComponentGVs(fieldName, fieldValue));
    }

    private List<GenericValue> findComponentGVs(String fieldName, Object fieldValue) {
        return this.delegator.findByAnd("Component", MapBuilder.build((Object)fieldName, (Object)fieldValue));
    }

    private List<GenericValue> findComponentGVs(String fieldName, Object fieldValue, String orderByField) {
        return this.delegator.findByAnd("Component", MapBuilder.build((Object)fieldName, (Object)fieldValue), CollectionBuilder.list((Object[])new String[]{orderByField}));
    }
}

