/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.index;

import com.atlassian.jira.config.IndexTask;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;

public class ProjectIndexTaskContext
implements IndexTask {
    private static final long serialVersionUID = -1875765202444481474L;
    private final Long projectId;
    private final String projectName;
    private final String nodeId;

    public ProjectIndexTaskContext(Project project, String nodeId) {
        this.nodeId = nodeId;
        this.projectId = project.getId();
        this.projectName = project.getName();
    }

    @Override
    public String getTaskInProgressMessage(I18nHelper i18n) {
        return i18n.getText("admin.notifications.reindex.in.progress.project", this.projectName);
    }

    @Override
    public String buildProgressURL(Long taskId) {
        return "/secure/project/IndexProjectProgress.jspa?pid=" + this.projectId + "&taskId=" + taskId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectIndexTaskContext)) {
            return false;
        }
        ProjectIndexTaskContext that = (ProjectIndexTaskContext)o;
        if (!this.projectId.equals(that.projectId)) {
            return false;
        }
        if (this.nodeId == null) {
            return that.nodeId == null;
        }
        return this.nodeId.equals(that.nodeId);
    }

    public int hashCode() {
        int result = this.projectId.hashCode();
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ProjectIndexTaskContext{projectId=" + this.projectId + ", projectName='" + this.projectName + '\'' + ", nodeId='" + this.nodeId + '\'' + '}';
    }
}

