/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.subtask.conversion;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.subtask.conversion.IssueConversionService;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.transformers.IssueChangeHolderTransformer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;

public abstract class DefaultIssueConversionService
implements IssueConversionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueConversionService.class);
    private final PermissionManager permissionManager;
    private final WorkflowManager workflowManager;
    protected final FieldLayoutManager fieldLayoutManager;
    protected final IssueTypeSchemeManager issueTypeSchemeManager;
    protected final JiraAuthenticationContext jiraAuthenticationContext;
    protected final FieldManager fieldManager;
    private final IssueEventManager issueEventManager;
    private final IssueEventBundleFactory issueEventBundleFactory;
    private final TxnAwareEventFactory txnAwareEventFactory;

    public DefaultIssueConversionService(PermissionManager permissionManager, WorkflowManager workflowManager, FieldLayoutManager fieldLayoutManager, IssueTypeSchemeManager issueTypeSchemeManager, JiraAuthenticationContext jiraAuthenticationContext, FieldManager fieldManager, IssueEventManager issueEventManager, IssueEventBundleFactory issueEventBundleFactory, TxnAwareEventFactory txnAwareEventFactory) {
        this.permissionManager = permissionManager;
        this.workflowManager = workflowManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldManager = fieldManager;
        this.issueEventManager = issueEventManager;
        this.issueEventBundleFactory = issueEventBundleFactory;
        this.txnAwareEventFactory = txnAwareEventFactory;
    }

    public boolean hasPermission(JiraServiceContext context, Issue issue) {
        return this.permissionManager.hasPermission(this.getPermissionNeeded(), issue, context.getLoggedInApplicationUser());
    }

    protected int getPermissionNeeded() {
        return 12;
    }

    public boolean isStatusChangeRequired(JiraServiceContext context, Issue issue, IssueType issueType) {
        String subTaskId;
        Long projectId;
        Status status = issue.getStatusObject();
        return !this.isStatusInWorkflowForProjectAndIssueType(status, projectId = issue.getProjectId(), subTaskId = issueType.getId());
    }

    public void validateTargetStatus(JiraServiceContext context, Status status, String fieldName, Issue issue, IssueType issueType) {
        Long projectId = issue.getProjectId();
        String subTaskId = issueType.getId();
        ErrorCollection errorCollection = context.getErrorCollection();
        if (!this.isStatusChangeRequired(context, issue, issueType) && !status.getId().equals(issue.getStatusObject().getId())) {
            errorCollection.addErrorMessage(this.getText("convert.issue.to.subtask.errormessage.nochangeneeded"));
        }
        if (!this.isStatusInWorkflowForProjectAndIssueType(status, projectId, subTaskId)) {
            errorCollection.addError(fieldName, this.getText("convert.issue.to.subtask.error.invalidstatusfortargetworkflow", status.getNameTranslation()));
        }
    }

    protected boolean isStatusInWorkflowForProjectAndIssueType(Status status, Long projectId, String issueTypeId) {
        List linkedStatusObjects = this.getWorkflowForProjectAndIssueType(projectId, issueTypeId).getLinkedStatusObjects();
        for (Status wfStatus : linkedStatusObjects) {
            if (!wfStatus.getId().equals(status.getId())) continue;
            return true;
        }
        return false;
    }

    private JiraWorkflow getWorkflowForProjectAndIssueType(Long projectId, String issueTypeId) {
        try {
            return this.workflowManager.getWorkflow(projectId, issueTypeId);
        }
        catch (WorkflowException e) {
            String msg = "Failed retrieving workflow for project: " + projectId + " and issue type:" + issueTypeId;
            log.error(msg, (Throwable)e);
            throw new DataAccessException(msg, (Throwable)e);
        }
    }

    public Collection<FieldLayoutItem> getFieldLayoutItems(Issue originalIssue, Issue targetIssue) {
        ArrayList<FieldLayoutItem> convertFieldLayoutItems = new ArrayList<FieldLayoutItem>();
        FieldLayout targetFieldLayout = this.getFieldLayout(targetIssue);
        Project targetProject = targetIssue.getProjectObject();
        List<String> issueTypeIds = Arrays.asList(targetIssue.getIssueTypeId());
        List visibleLayoutItems = targetFieldLayout.getVisibleLayoutItems(targetProject, issueTypeIds);
        for (FieldLayoutItem fieldLayoutItem : visibleLayoutItems) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            if ("issuetype".equals(orderableField.getId()) || this.canIssueSecurityFieldIgnore() && "security".equals(orderableField.getId()) || !orderableField.needsMove((Collection)EasyList.build((Object)originalIssue), targetIssue, fieldLayoutItem).getResult()) continue;
            convertFieldLayoutItems.add(fieldLayoutItem);
        }
        Collections.sort(convertFieldLayoutItems);
        return convertFieldLayoutItems;
    }

    protected abstract boolean canIssueSecurityFieldIgnore();

    private FieldLayout getFieldLayout(Issue issue) {
        return this.fieldLayoutManager.getFieldLayout(issue);
    }

    public void populateFields(JiraServiceContext context, OperationContext operationContext, I18nHelper i18nHelper, Issue targetIssue, Collection<FieldLayoutItem> fieldLayoutItems) {
        ErrorCollection errorCollection = context.getErrorCollection();
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            if (orderableField.isShown(targetIssue)) {
                orderableField.populateFromParams(operationContext.getFieldValuesHolder(), ActionContext.getParameters());
                orderableField.validateParams(operationContext, errorCollection, i18nHelper, targetIssue, (FieldScreenRenderLayoutItem)new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
                continue;
            }
            orderableField.populateDefaults(operationContext.getFieldValuesHolder(), targetIssue);
            orderableField.validateParams(operationContext, errorCollection, i18nHelper, targetIssue, (FieldScreenRenderLayoutItem)new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
        }
    }

    public Collection<OrderableField> getRemovedFields(Issue origIssue, Issue targetIssue) {
        ArrayList<OrderableField> removedFields = new ArrayList<OrderableField>();
        FieldLayout targetFieldLayout = this.getFieldLayout(targetIssue);
        List hiddenFields = targetFieldLayout.getHiddenFields(targetIssue.getProjectObject(), Arrays.asList(targetIssue.getIssueTypeId()));
        for (Field field : hiddenFields) {
            if (field == null || !this.fieldManager.isOrderableField(field)) continue;
            boolean doValueCheck = this.isShouldCheckFieldValue(origIssue, field);
            OrderableField orderableField = (OrderableField)field;
            if (!doValueCheck || !orderableField.hasValue(targetIssue) || !orderableField.canRemoveValueFromIssueObject(targetIssue)) continue;
            removedFields.add(orderableField);
        }
        return removedFields;
    }

    protected boolean isShouldCheckFieldValue(Issue origIssue, Field field) {
        boolean doValueCheck = true;
        List<String> issueTypeList = Arrays.asList(origIssue.getIssueTypeId());
        if (this.fieldManager.isCustomField(field) && !((CustomField)field).isInScope(origIssue.getProjectObject(), issueTypeList)) {
            doValueCheck = false;
        }
        return doValueCheck;
    }

    public void validateFields(JiraServiceContext context, OperationContext operationContext, I18nHelper i18nHelper, Issue targetIssue, Collection<FieldLayoutItem> fieldLayoutItems) {
        ErrorCollection errorCollection = context.getErrorCollection();
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            orderableField.validateParams(operationContext, errorCollection, i18nHelper, targetIssue, (FieldScreenRenderLayoutItem)new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
        }
    }

    private IssueChangeHolder convertIssueDetails(JiraServiceContext context, Issue currentIssue, MutableIssue targetIssue) {
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        if (!currentIssue.getWorkflowId().equals(targetIssue.getWorkflowId())) {
            JiraWorkflow currentWorkflow = this.getWorkflowForIssue(currentIssue);
            JiraWorkflow targetWorkflow = this.getWorkflowForIssue((Issue)targetIssue);
            changeHolder.addChangeItem(new ChangeItemBean("jira", "Workflow", currentIssue.getWorkflowId().toString(), currentWorkflow.getName(), targetIssue.getWorkflowId().toString(), targetWorkflow.getName()));
            Status currentStatus = currentIssue.getStatusObject();
            Status targetStatus = targetIssue.getStatusObject();
            if (!currentStatus.getId().equals(targetStatus.getId())) {
                changeHolder.addChangeItem(new ChangeItemBean("jira", "status", currentStatus.getId(), currentStatus.getName(), targetStatus.getId(), targetStatus.getName()));
            }
        }
        this.preStoreUpdates(context, (IssueChangeHolder)changeHolder, currentIssue, targetIssue);
        targetIssue.store();
        Map modifiedFields = targetIssue.getModifiedFields();
        for (String fieldId : modifiedFields.keySet()) {
            if (!this.fieldManager.isOrderableField(fieldId)) continue;
            OrderableField field = this.fieldManager.getOrderableField(fieldId);
            FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout((Issue)targetIssue).getFieldLayoutItem(field);
            field.updateValue(fieldLayoutItem, (Issue)targetIssue, (ModifiedValue)modifiedFields.get(fieldId), (IssueChangeHolder)changeHolder);
        }
        targetIssue.resetModifiedFields();
        return changeHolder;
    }

    private JiraWorkflow getWorkflowForIssue(Issue issue) {
        return this.getWorkflowForProjectAndIssueType(issue.getProjectId(), issue.getIssueTypeId());
    }

    public void convertIssue(JiraServiceContext context, Issue currentIssue, MutableIssue updatedIssue) {
        this.migrateWorkflowIfNecessary(currentIssue, updatedIssue);
        updatedIssue.setUpdated(new Timestamp(System.currentTimeMillis()));
        IssueChangeHolder issueChangeHolder = this.convertIssueDetails(context, currentIssue, updatedIssue);
        GenericValue updateLog = ChangeLogUtils.createChangeGroup(context.getLoggedInUser(), currentIssue, (Issue)updatedIssue, (Collection<ChangeItemBean>)issueChangeHolder.getChangeItems(), false);
        if (updateLog != null) {
            this.txnAwareEventFactory.issueChangedEventOnCommit(updatedIssue.getId(), context.getLoggedInApplicationUser(), issueChangeHolder.getComment(), updateLog.getLong("id"), true);
            if (!issueChangeHolder.getChangeItems().isEmpty()) {
                this.dispatchEvents((Issue)updatedIssue, context, updateLog, issueChangeHolder);
            }
        }
    }

    @VisibleForTesting
    void dispatchEvents(Issue updatedIssue, JiraServiceContext context, GenericValue updateLog, IssueChangeHolder issueChangeHolder) {
        Long eventType = EventType.ISSUE_UPDATED_ID;
        ApplicationUser applicationUser = context.getLoggedInApplicationUser();
        this.issueEventManager.dispatchRedundantEvent(eventType, updatedIssue, context.getLoggedInUser(), updateLog, true, issueChangeHolder.isSubtasksUpdated());
        IssueUpdateBean issueUpdateBean = IssueChangeHolderTransformer.toIssueUpdateBean(issueChangeHolder, eventType, applicationUser, true);
        IssueEventBundle issueUpdateEventBundle = this.issueEventBundleFactory.createIssueUpdateEventBundle(updatedIssue, updateLog, issueUpdateBean, applicationUser);
        this.issueEventManager.dispatchEvent(issueUpdateEventBundle);
    }

    private void migrateWorkflowIfNecessary(Issue currentIssue, MutableIssue updatedIssue) {
        JiraWorkflow currentWorkflow = this.getWorkflowForIssue(currentIssue);
        JiraWorkflow targetWorkflow = this.getWorkflowForIssue((Issue)updatedIssue);
        if (!targetWorkflow.equals(currentWorkflow)) {
            try {
                this.workflowManager.migrateIssueToWorkflow(updatedIssue, targetWorkflow, updatedIssue.getStatusObject());
            }
            catch (WorkflowException e) {
                String msg = "Could not migrate to sub-task workflow for issue: " + currentIssue.getKey();
                log.error(msg, (Throwable)e);
                throw new DataAccessException(msg, (Throwable)e);
            }
        }
    }

    protected String getText(String key) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key);
    }

    protected String getText(String key, Object param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }

    protected String getText(String key, String param0, String param1) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param0, param1);
    }
}

