/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.annotations.Internal;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.bc.user.EffectiveApplication;
import com.atlassian.jira.bc.user.GroupView;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONArray;
import com.google.common.base.Objects;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@Internal
public interface UserApplicationHelper {
    @Nonnull
    public List<ApplicationSelection> getApplicationsForSelection(@Nonnull Set<ApplicationKey> var1, @Nonnull Optional<Long> var2);

    @Nonnull
    public List<ApplicationSelection> getApplicationsForUser(@Nonnull ApplicationUser var1);

    @Nonnull
    public List<GroupView> getUserGroups(@Nonnull ApplicationUser var1);

    @Nonnull
    public Collection<String> validateDefaultApplications(EnumSet<ValidationScope> var1, Optional<Long> var2);

    @Nonnull
    public Collection<String> validateApplicationKeys(@Nonnull Optional<Long> var1, @Nonnull Set<ApplicationKey> var2);

    @Nonnull
    public Collection<String> validateApplicationKeys(@Nonnull Optional<Long> var1, @Nonnull Set<ApplicationKey> var2, @Nonnull EnumSet<ValidationScope> var3);

    @Nonnull
    public Collection<String> validateApplicationKeys(@Nonnull ApplicationUser var1, @Nonnull Set<ApplicationKey> var2);

    public boolean canUserLogin(@Nullable ApplicationUser var1);

    @JsonAutoDetect
    public static final class ApplicationSelection
    implements Comparable<ApplicationSelection> {
        private final ApplicationKey key;
        private final String name;
        private final String displayName;
        private final String message;
        private final String messageMarkup;
        private final boolean selectable;
        private final boolean selected;
        private final boolean defined;
        private final boolean deselectable;
        private final boolean indeterminate;
        private final boolean effectiveOfOtherApplication;
        private final Set<EffectiveApplication> effectiveApplications;

        ApplicationSelection(@Nonnull ApplicationKey key, @Nonnull String name, @Nonnull String displayName, @Nullable String message, @Nullable String messageMarkup, boolean selectable, boolean selected, boolean defined, boolean indeterminate, boolean effectiveOfOtherApplication, boolean deselectable, @Nullable Set<EffectiveApplication> effectiveApplications) {
            this.key = key;
            this.name = name;
            this.displayName = displayName;
            this.message = message;
            this.messageMarkup = messageMarkup;
            this.selectable = selectable;
            this.selected = selected;
            this.defined = defined;
            this.indeterminate = indeterminate;
            this.effectiveOfOtherApplication = effectiveOfOtherApplication;
            this.deselectable = deselectable;
            this.effectiveApplications = effectiveApplications;
        }

        public String getKey() {
            return this.key.value();
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageMarkup() {
            return this.messageMarkup;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public boolean isIndeterminate() {
            return this.indeterminate;
        }

        public boolean isEffectiveOfOtherApplication() {
            return this.effectiveOfOtherApplication;
        }

        public boolean isDeselectable() {
            return this.deselectable;
        }

        public Set<EffectiveApplication> getEffectiveApplications() {
            return this.effectiveApplications;
        }

        public String getEffectiveApplicationsJson() {
            return new JSONArray((Collection)this.effectiveApplications.stream().map(EffectiveApplication::getKey).collect(CollectorsUtil.toImmutableSet())).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationSelection that = (ApplicationSelection)o;
            return Objects.equal((Object)this.selectable, (Object)that.selectable) && Objects.equal((Object)this.selected, (Object)that.selected) && Objects.equal((Object)this.indeterminate, (Object)that.indeterminate) && Objects.equal((Object)this.effectiveOfOtherApplication, (Object)that.effectiveOfOtherApplication) && Objects.equal((Object)this.deselectable, (Object)that.deselectable) && Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.displayName, (Object)that.displayName) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.message, (Object)that.message) && Objects.equal(this.effectiveApplications, that.effectiveApplications) && Objects.equal((Object)this.defined, (Object)that.defined) && Objects.equal((Object)this.messageMarkup, (Object)that.messageMarkup);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.key, this.displayName, this.name, this.message, this.selectable, this.selected, this.indeterminate, this.deselectable, this.effectiveApplications, this.defined, this.messageMarkup});
        }

        @Override
        public int compareTo(@Nullable ApplicationSelection other) {
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return -1;
            }
            if (this.key.equals((Object)other.key)) {
                return this.compareDisplayName(other);
            }
            if (ApplicationKeys.CORE.equals((Object)this.key)) {
                return 1;
            }
            if (ApplicationKeys.CORE.equals((Object)other.key)) {
                return -1;
            }
            return this.compareDisplayName(other);
        }

        private int compareDisplayName(ApplicationSelection other) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.displayName, other.displayName);
        }

        public String toString() {
            return "ApplicationSelection{key=" + this.key + ", name='" + this.name + '\'' + ", displayName='" + this.displayName + '\'' + ", message='" + this.message + '\'' + ", messageMarkup='" + this.messageMarkup + '\'' + ", selectable=" + this.selectable + ", selected=" + this.selected + ", defined=" + this.defined + ", deselectable=" + this.deselectable + ", indeterminate=" + this.indeterminate + ", effectiveOfOtherApplication=" + this.effectiveOfOtherApplication + ", effectiveApplications=" + this.effectiveApplications + '}';
        }
    }

    public static enum ValidationScope {
        ACCESS,
        SEATS,
        EXPIRE;

    }
}

