/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.slomo;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cache.slomo.SloMoCache;
import com.atlassian.jira.cache.slomo.SloMoCachedReference;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SloMoCacheManager
implements CacheManager {
    private final CacheManager delegate;
    private final int delay;

    @Deprecated
    @Nonnull
    public Collection<Cache<?, ?>> getCaches() {
        return this.delegate.getCaches();
    }

    @Nonnull
    public Collection<ManagedCache> getManagedCaches() {
        return this.delegate.getManagedCaches();
    }

    public void flushCaches() {
        this.delegate.flushCaches();
    }

    @Nullable
    public ManagedCache getManagedCache(String name) {
        return this.delegate.getManagedCache(name);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier) {
        return this.wrap(this.delegate.getCachedReference(name, supplier));
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier, CacheSettings cacheSettings) {
        CachedReference ref = this.delegate.getCachedReference(name, supplier, cacheSettings);
        return SloMoCacheManager.isLocal(cacheSettings) ? ref : this.wrap(ref);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier) {
        return this.wrap(this.delegate.getCachedReference(owningClass, name, supplier));
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier, CacheSettings cacheSettings) {
        CachedReference ref = this.delegate.getCachedReference(owningClass, name, supplier, cacheSettings);
        return SloMoCacheManager.isLocal(cacheSettings) ? ref : this.wrap(ref);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name) {
        return this.wrap(this.delegate.getCache(name));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(Class<?> owningClass, String name) {
        return this.wrap(this.delegate.getCache(owningClass, name));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, @Nullable CacheLoader<K, V> cacheLoader) {
        return this.wrap(this.delegate.getCache(name, cacheLoader));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, @Nullable CacheLoader<K, V> cacheLoader, CacheSettings cacheSettings) {
        Cache<K, V> cache = this.delegate.getCache(name, cacheLoader, cacheSettings);
        return SloMoCacheManager.isLocal(cacheSettings) ? cache : this.wrap(cache);
    }

    @Deprecated
    @Nonnull
    public <K, V> Cache<K, V> getCache(String name, Class<K> keyClass, Class<V> valueClass) {
        return this.wrap(this.delegate.getCache(name, keyClass, valueClass));
    }

    public SloMoCacheManager(CacheManager delegate, int delay) {
        this.delegate = delegate;
        this.delay = delay;
    }

    private <T> CachedReference<T> wrap(CachedReference<T> delegate) {
        return new SloMoCachedReference<T>(this, delegate);
    }

    private <K, V> Cache<K, V> wrap(Cache<K, V> delegate) {
        return new SloMoCache<K, V>(this, delegate);
    }

    private static boolean isLocal(CacheSettings settings) {
        return Boolean.TRUE.equals(settings.getLocal());
    }

    void sleep() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException ie) {
            throw new CacheException("Interrupted inside cache delay", (Throwable)ie);
        }
    }
}

