/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.util.concurrent.TimeUnit;

public class LocalQConfig {
    public static final int MAX_NUMBER_OF_RMI_NOT_BOUND_ERRORS_DEFAULT = 2;
    public static final int MAX_NUMBER_OF_UNRECOVERABLE_ERRORS_DEFAULT = 10;
    public static final int NUMBER_OF_QUEUES_PER_NODE = 10;
    public static final String LOCALQ_REPLICATION_DISABLED = "jira.cache.replication.localq.disabled";
    public static final String LOCALQ_REPLICATION_DISABLED_DEFAULT = Boolean.FALSE.toString();
    public static final String LOCALQ_NODE_TIME_SYNC_TOLERANCE_MILLIS = "jira.cache.replication.localq.time.sync.tolerance.millis";
    public static final long LOCALQ_NODE_TIME_SYNC_TOLERANCE_MILLIS_DEFAULT = TimeUnit.MINUTES.toMillis(15L);
    public static final String LOCALQ_MAX_QUEUE_SIZE = "jira.cache.replication.localq.queue.max.size";
    public static final int LOCALQ_MAX_QUEUE_SIZE_DEFAULT = 100000;
    public static final String LOCALQ_STATS_LOGGING_INTERVAL_SECONDS = "jira.cache.replication.localq.queue.stats.logging.interval.seconds";
    public static final long LOCALQ_STATS_LOGGING_INTERVAL_SECONDS_DEFAULT = 60L;

    public static boolean isLocalQReplicationDisabled() {
        return Boolean.parseBoolean(JiraSystemProperties.getInstance().getProperty(LOCALQ_REPLICATION_DISABLED, LOCALQ_REPLICATION_DISABLED_DEFAULT));
    }

    public static long nodeTimeSynchronisationToleranceMillis() {
        return Integer.parseInt(JiraSystemProperties.getInstance().getProperty(LOCALQ_NODE_TIME_SYNC_TOLERANCE_MILLIS, LOCALQ_NODE_TIME_SYNC_TOLERANCE_MILLIS_DEFAULT + ""));
    }

    public static int maximumNumberOfMessagesPerQueue() {
        return Integer.parseInt(JiraSystemProperties.getInstance().getProperty(LOCALQ_MAX_QUEUE_SIZE, "100000"));
    }

    public static long statsLoggingIntervalSeconds() {
        return Long.parseLong(JiraSystemProperties.getInstance().getProperty(LOCALQ_STATS_LOGGING_INTERVAL_SECONDS, "60"));
    }
}

