/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq.tape;

import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOp;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOpQueue;
import com.atlassian.jira.cluster.distribution.localq.LocalQConfig;
import com.atlassian.jira.cluster.distribution.localq.tape.TapeFileObjectQueue;
import com.atlassian.jira.cluster.distribution.localq.tape.TapeLocalQCacheOpConverter;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.squareup.tape.FileObjectQueue;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapeLocalQCacheOpQueue
implements LocalQCacheOpQueue {
    private static final Logger LOG = LoggerFactory.getLogger(TapeLocalQCacheOpQueue.class);
    private static final int LOG_DROPPED_FREQUENCY = 1000;
    private final File localDirectoryForQueues;
    private final LocalQCacheOpQueue.QueueId id;
    private FileObjectQueue<LocalQCacheOp> queue;
    private File queueFile;
    private final int maxQueueSize;
    private final Supplier<FileObjectQueue.Converter<LocalQCacheOp>> localQCacheOpConverterSupplier;
    private final AtomicBoolean queueOpen;
    private final Lock lock = new ReentrantLock();
    private final Condition queueNotEmpty = this.lock.newCondition();
    private final AtomicLong droppedCounter = new AtomicLong(0L);

    TapeLocalQCacheOpQueue(File localDirectoryForQueues, Node node, int nodeQueueNumber, int maxQueueSize, Supplier<FileObjectQueue.Converter<LocalQCacheOp>> localQCacheOpConverterSupplier) throws IOException {
        Preconditions.checkNotNull((Object)localDirectoryForQueues);
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkArgument((nodeQueueNumber >= 0 && nodeQueueNumber < 10 ? 1 : 0) != 0, (String)"incorrect nodeQueueNumber: %s, valid values [%s,%s]", (Object)nodeQueueNumber, (Object)0, (Object)9);
        Preconditions.checkArgument((maxQueueSize > 0 ? 1 : 0) != 0, (Object)"max queue size must be > 0");
        this.localDirectoryForQueues = localDirectoryForQueues;
        this.id = LocalQCacheOpQueue.QueueId.create(node.getNodeId(), nodeQueueNumber);
        this.localQCacheOpConverterSupplier = localQCacheOpConverterSupplier;
        this.initQueue(localQCacheOpConverterSupplier);
        LOG.info("Created persistent cache replication queue for node: {} with id: {} in : {}", new Object[]{this.id.nodeId, this.id.filename(), this.queueFile.getPath()});
        this.queueOpen = new AtomicBoolean(true);
        this.maxQueueSize = maxQueueSize;
    }

    private void initQueue(Supplier<FileObjectQueue.Converter<LocalQCacheOp>> localQCacheOpConverterSupplier) throws IOException {
        this.lock.lock();
        try {
            this.queueFile = TapeLocalQCacheOpQueue.getFileForNode(this.localDirectoryForQueues, this.id);
            this.queue = TapeFileObjectQueue.create(this.queueFile, localQCacheOpConverterSupplier.get());
        }
        finally {
            this.lock.unlock();
        }
    }

    private static File getFileForNode(File jiraLocalHome, LocalQCacheOpQueue.QueueId queueId) {
        return new File(jiraLocalHome, queueId.filename());
    }

    public static TapeLocalQCacheOpQueue create(File localDirectoryForQueues, Node node, int nodeQueueNumber) throws IOException {
        return new TapeLocalQCacheOpQueue(localDirectoryForQueues, node, nodeQueueNumber, LocalQConfig.maximumNumberOfMessagesPerQueue(), TapeLocalQCacheOpConverter::new);
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.queueOpen.set(false);
            this.queueNotEmpty.signalAll();
            this.queue.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isClosed() {
        this.lock.lock();
        try {
            boolean bl = !this.queueOpen.get();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void validateQueueOpen() {
        this.lock.lock();
        try {
            if (!this.queueOpen.get()) {
                throw new IllegalStateException("Cache replication queue is not open.");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String name() {
        return String.format("[queueId=%s, queuePath=%s]", this.id(), this.queueFile.getPath());
    }

    @Override
    public LocalQCacheOpQueue.QueueId id() {
        return this.id;
    }

    @Override
    public boolean add(LocalQCacheOp localQCacheOp) throws IllegalStateException {
        if (this.dropping()) {
            return false;
        }
        this.lock.lock();
        try {
            this.validateQueueOpen();
            this.queue.add((Object)localQCacheOp);
            this.queueNotEmpty.signalAll();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean dropping() {
        this.lock.lock();
        try {
            int queueSize = this.queue.size();
            if (queueSize >= this.maxQueueSize) {
                this.droppedCounter.incrementAndGet();
                if (this.droppedCounter.get() == 1L || this.droppedCounter.get() % 1000L == 0L) {
                    LOG.warn("Cache replication queue is full (size: {}). Cache replication events are dropped and not added to this queue: {}. Number of dropped cache replication events: {}. Probably node: {} is unreachable. If this is a desired state please shut down this node properly, i.e make sure it is not in state: {} in the DB: {}. If this is not expected caches on node: {} are now inconsistent with this node. Maximum queue size can be set via system property: {}. ", new Object[]{queueSize, this.name(), this.droppedCounter.get(), this.id.nodeId, Node.NodeState.ACTIVE, "clusternode", this.id.nodeId, "jira.cache.replication.localq.queue.max.size"});
                }
                boolean bl = true;
                return bl;
            }
            this.droppedCounter.set(0L);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public LocalQCacheOp peek() {
        this.lock.lock();
        try {
            this.validateQueueOpen();
            LocalQCacheOp localQCacheOp = (LocalQCacheOp)this.queue.peek();
            return localQCacheOp;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public LocalQCacheOp peekOrBlock() throws InterruptedException, IllegalStateException {
        this.lock.lock();
        try {
            this.validateQueueOpen();
            while (this.queue.size() == 0 && this.queueOpen.get()) {
                this.queueNotEmpty.await();
            }
            if (!this.queueOpen.get()) {
                LocalQCacheOp localQCacheOp = null;
                return localQCacheOp;
            }
            LocalQCacheOp localQCacheOp = this.peek();
            return localQCacheOp;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remove() throws NoSuchElementException, IllegalStateException {
        this.lock.lock();
        try {
            this.validateQueueOpen();
            this.queue.remove();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupQueue(String prefix) throws IOException {
        this.lock.lock();
        try {
            String newName = prefix + "_" + this.queueFile.getName();
            this.queue.close();
            File newFile = new File(this.queueFile.getParent(), newName);
            if (newFile.exists()) {
                newFile.delete();
            }
            Files.move((File)this.queueFile, (File)newFile);
            this.initQueue(this.localQCacheOpConverterSupplier);
            LOG.warn("Re-created persistent cache replication queue for node: {} with id: {} in : {}", new Object[]{this.id.nodeId, this.id.filename(), this.queueFile.getPath()});
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long usableSpaceInBytes() {
        this.lock.lock();
        try {
            long usableSpace = this.queueFile.getUsableSpace();
            if (usableSpace == 0L) {
                Long l = null;
                return l;
            }
            Long l = usableSpace;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasPermission() {
        this.lock.lock();
        try {
            boolean bl = this.queueFile.canRead() && this.queueFile.canWrite();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TapeLocalQCacheOpQueue that = (TapeLocalQCacheOpQueue)o;
        return Objects.equals(this.localDirectoryForQueues, that.localDirectoryForQueues) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.localDirectoryForQueues, this.id);
    }
}

