/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.health;

import com.atlassian.jira.appconsistency.JiraSetupConfig;
import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.license.ClusterLicenseCheck;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.web.action.admin.ConfirmNewInstallationWithOldLicense;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import com.atlassian.johnson.setup.SetupConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ClusterLicenseHealthCheck
extends HealthCheckTemplate {
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/Cb3xN");
    private final SetupConfig setupConfig;
    private final Supplier<ClusterInfo> clusterInfoSupplier;
    private final Supplier<ClusterLicenseCheck> licenseCheckSupplier;

    public static ClusterLicenseHealthCheck getInstance(HealthCheck ... prerequisites) {
        return new ClusterLicenseHealthCheck(ComponentAccessor.supplierOf(ClusterLicenseCheck.class), new JiraSetupConfig(), ComponentAccessor.supplierOf(ClusterInfo.class), prerequisites);
    }

    @VisibleForTesting
    ClusterLicenseHealthCheck(Supplier<ClusterLicenseCheck> licenseCheckSupplier, SetupConfig setupConfig, Supplier<ClusterInfo> clusterInfoSupplier, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.licenseCheckSupplier = Objects.requireNonNull(licenseCheckSupplier);
        this.setupConfig = Objects.requireNonNull(setupConfig);
        this.clusterInfoSupplier = Objects.requireNonNull(clusterInfoSupplier);
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        if (!this.shouldRun()) {
            return Collections.emptyList();
        }
        ClusterLicenseCheck.ClusterResult checkResult = this.licenseCheckSupplier.get().evaluate();
        if (checkResult.isPass()) {
            return Collections.emptyList();
        }
        return this.getHealthCheckResultForReason(Objects.requireNonNull(checkResult.getReason()));
    }

    private boolean shouldRun() {
        return this.setupConfig.isSetup() && this.clusterInfoSupplier.get().isClustered();
    }

    private List<HealthCheckResult> getHealthCheckResultForReason(ClusterLicenseCheck.FailureReason reason) {
        switch (reason) {
            case NO_LICENSES: {
                return this.getResultForMissingLicense();
            }
            case MIXED_LICENSES: {
                return this.getResultForMixedLicense();
            }
            case NO_DC_LICENSE: {
                return this.getResultForMissingDataCenterLicense();
            }
        }
        throw new IllegalArgumentException("Need valid reason to fail. Given unknown reason: " + (Object)((Object)reason));
    }

    private List<HealthCheckResult> getResultForMissingLicense() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("JIRA is set up to run as a Data Center instance, but it doesn't have a valid Data Center license. You can obtain a valid Data Center license from ")).appendLink("http://my.atlassian.com", "my.atlassian.com", true).append(HealthCheckMessageFormatter.string(", and add the Data Center ")).appendLink(ClusterLicenseHealthCheck.getLicenseEntryPath(), "license here.", false).addLineBreak().addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on licensing errors."));
        return HealthCheckResult.fail(this, this.getEvent("We can't detect a JIRA Data Center license", messageFormatter), KB_URL, "missing-license", messageFormatter.toText());
    }

    private List<HealthCheckResult> getResultForMixedLicense() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("Your JIRA instance has a mixture of Data Center and non-Data Center licenses. To run JIRA as Data Center, all your licenses need to be Data Center compatible. You can obtain a valid Data Center license from ")).appendLink("http://my.atlassian.com", "my.atlassian.com", true).append(HealthCheckMessageFormatter.string(", and replace the ")).appendLink(ClusterLicenseHealthCheck.getLicenseEntryPath(), "invalid license here.", false).addLineBreak().addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on licensing errors."));
        return HealthCheckResult.fail(this, this.getEvent("We found a problem with your JIRA licenses", messageFormatter), KB_URL, "mixed-license", messageFormatter.toText());
    }

    private List<HealthCheckResult> getResultForMissingDataCenterLicense() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("JIRA is set up to run as a Data Center instance, but it doesn't have a valid Data Center license. You can obtain a valid Data Center license from ")).appendLink("http://my.atlassian.com", "my.atlassian.com", true).append(HealthCheckMessageFormatter.string(", and replace the ")).appendLink(ClusterLicenseHealthCheck.getLicenseEntryPath(), "current license here.", false).addLineBreak().addLineBreak().append(HealthCheckMessageFormatter.string("See our documentation for more information on licensing errors."));
        return HealthCheckResult.fail(this, this.getEvent("We found a problem with your JIRA license", messageFormatter), KB_URL, "missing-datacenter-license", messageFormatter.toText());
    }

    private Event getEvent(String title, HealthCheckMessageFormatter messageFormatter) {
        return new Event(JohnsonEventType.CLUSTERING_UNLICENSED.eventType(), title, messageFormatter.toHtml(), EventLevels.fatal());
    }

    private static String getLicenseEntryPath() {
        return ConfirmNewInstallationWithOldLicense.getRelativeUrl();
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.POST_CONSISTENCY_CHECKS));
    }
}

