/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.config.AbstractIssueConstantsManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PriorityImpl;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPriorityManager
extends AbstractIssueConstantsManager<Priority>
implements PriorityManager,
Startable {
    private static final String CREATION_LOCK_NAME = DefaultPriorityManager.class.getName() + ".creationLock";
    private final ApplicationProperties applicationProperties;
    private final IssueConstantFactory issueConstantFactory;
    private final ClusterLockService clusterLockService;
    private final IssueManager issueManager;
    private final PrioritySchemeManager prioritySchemeManager;
    private ClusterLock creationLock;
    private static final Logger log = LoggerFactory.getLogger(DefaultPriorityManager.class);

    public DefaultPriorityManager(ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, IssueIndexingService issueIndexingService, ApplicationProperties applicationProperties, IssueConstantFactory issueConstantFactory, ClusterLockService clusterLockService, IssueManager issueManager, QueryDslAccessor queryDslAccessor, PrioritySchemeManager prioritySchemeManager) {
        super(constantsManager, ofBizDelegator, issueIndexingService, issueManager, queryDslAccessor);
        this.applicationProperties = applicationProperties;
        this.issueConstantFactory = issueConstantFactory;
        this.clusterLockService = clusterLockService;
        this.issueManager = issueManager;
        this.prioritySchemeManager = prioritySchemeManager;
    }

    public void start() {
        this.creationLock = this.clusterLockService.getLockForName(CREATION_LOCK_NAME);
    }

    public Priority createPriority(String name, String description, String iconUrl, String color) {
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        Assertions.notBlank((String)"color", (String)color);
        this.creationLock.lock();
        try {
            Priority priority2;
            for (Priority priority2 : this.constantsManager.getPriorityObjects()) {
                if (!name.trim().equalsIgnoreCase(priority2.getName())) continue;
                throw new IllegalStateException("A priority with the name '" + name + "' already exists.");
            }
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", name);
            fields.put("description", description);
            fields.put("id", this.getNextStringId());
            fields.put("iconurl", iconUrl);
            fields.put("statusColor", color);
            fields.put("sequence", this.getMaxSequenceNo() + 1L);
            priority2 = this.issueConstantFactory.createPriority(this.createConstant(fields));
            this.prioritySchemeManager.addOptionToDefault(priority2.getId());
            Priority priority3 = priority2;
            return priority3;
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException("Failed to create a priority with name '" + name + "'", (Throwable)ex);
        }
        finally {
            this.creationLock.unlock();
            this.constantsManager.refreshPriorities();
        }
    }

    public void editPriority(Priority priority, String name, String description, String iconUrl, String color) {
        Assertions.notNull((String)"priority", (Object)priority);
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        Assertions.notBlank((String)"color", (String)color);
        for (Priority prio : this.getPriorities()) {
            if (!name.equalsIgnoreCase(prio.getName()) || priority.getId().equals(prio.getId())) continue;
            throw new IllegalStateException("Cannot rename priority. A priority with the name '" + name + "' exists already.");
        }
        try {
            PriorityImpl updatedPriority = (PriorityImpl)this.issueConstantFactory.createPriority(((PriorityImpl)priority).getGenericValue());
            updatedPriority.setName(name);
            updatedPriority.setDescription(description);
            updatedPriority.setIconUrl(iconUrl);
            updatedPriority.setStatusColor(color);
            updatedPriority.getGenericValue().store();
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update priority '" + priority.getName() + "'", (Throwable)e);
        }
    }

    public List<Priority> getPriorities() {
        return Lists.newArrayList((Iterable)this.constantsManager.getPriorityObjects());
    }

    public void removePriority(String id, String newPriorityId) {
        Assertions.notBlank((String)"id", (String)id);
        Assertions.notBlank((String)"newPriorityId", (String)newPriorityId);
        Priority priority = this.getPriority(id);
        if (priority == null) {
            throw new IllegalArgumentException("A priority with id '" + id + "' does not exist.");
        }
        Priority newPriority = this.getPriority(newPriorityId);
        if (newPriority == null) {
            throw new IllegalArgumentException("A priority with id '" + newPriorityId + "' does not exist.");
        }
        this.prioritySchemeManager.removeOptionFromAllSchemes(id);
        try {
            this.removeConstant(QIssue.ISSUE.priority, priority, newPriority.getId());
        }
        catch (Exception ex) {
            throw new DataAccessException("Failed to remove priority '" + id + "'", (Throwable)ex);
        }
    }

    public Priority getPriority(String id) {
        Assertions.notBlank((String)"id", (String)id);
        return this.constantsManager.getPriorityObject(id);
    }

    public void setDefaultPriority(String id) {
        if (id != null && this.getPriority(id) == null) {
            throw new IllegalArgumentException("A priority with id '" + id + "' does not exist.");
        }
        this.applicationProperties.setString("jira.constant.default.priority", id);
    }

    public Priority getDefaultPriority() {
        String priorityId = this.applicationProperties.getString("jira.constant.default.priority");
        if (StringUtils.isNotEmpty((CharSequence)priorityId)) {
            Priority priority = this.getPriority(priorityId);
            if (priority == null) {
                log.warn("Default priority with id '" + priorityId + "' does not exist.");
            }
            return priority;
        }
        return null;
    }

    public void movePriorityUp(String id) {
        Priority priority = this.getPriority(id);
        if (priority == null) {
            throw new IllegalArgumentException("A priority with id '" + id + "' does not exist.");
        }
        this.moveUp(priority);
    }

    public void movePriorityDown(String id) {
        Priority priority = this.getPriority(id);
        if (priority == null) {
            throw new IllegalArgumentException("A priority with id '" + id + "' does not exist.");
        }
        this.moveDown(priority);
    }

    protected List<Priority> getValues() {
        return this.getPriorities();
    }

    @Override
    protected void postProcess(Priority priority) {
        if (priority.getId().equals(this.applicationProperties.getString("jira.constant.default.priority"))) {
            this.applicationProperties.setString("jira.constant.default.priority", null);
        }
    }

    @Override
    protected void clearCaches() {
        this.constantsManager.refreshPriorities();
    }

    @Override
    protected String getIssueConstantField() {
        return ConstantsManager.PRIORITY_CONSTANT_TYPE;
    }

    @Override
    protected List<Priority> getAllValues() {
        return this.getPriorities();
    }
}

