/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.feature.FeatureFlagActivator;
import com.atlassian.jira.config.properties.SystemPropertiesAccessor;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

public class DCLockLeasingActivator
implements FeatureFlagActivator {
    public static final String DC_LOCK_LEASING_ENABLED = "jira.lock.leasing.enabled";
    private static final Integer DC_LOCK_LEASING_ACTIVATION_VERSION = 803001;
    private final BuildUtilsInfo buildUtilsInfo;
    private final boolean enabledByConfiguration;

    public DCLockLeasingActivator(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.enabledByConfiguration = this.parseBoolean(new SystemPropertiesAccessor().getProperty(DC_LOCK_LEASING_ENABLED), true);
    }

    @Nonnull
    public Set<FeatureFlag> getActivatedFlags() {
        boolean databaseNumberValid;
        int databaseBuildNumber = this.buildUtilsInfo.getDatabaseBuildNumber();
        boolean bl = databaseNumberValid = databaseBuildNumber >= DC_LOCK_LEASING_ACTIVATION_VERSION;
        if (databaseNumberValid && this.enabledByConfiguration) {
            return ImmutableSet.of((Object)JiraFeatureFlagRegistrar.USE_DC_LOCK_LEASING);
        }
        return Collections.emptySet();
    }

    private boolean parseBoolean(String property, boolean defaultValue) {
        if ("true".equals(property)) {
            return true;
        }
        if ("false".equals(property)) {
            return false;
        }
        return defaultValue;
    }
}

