/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.feature.FeatureFlagActivatorAccessor;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class FeatureFlagDataProvider
implements WebResourceDataProvider {
    private final FeatureManager featureManager;
    private final FeatureFlagActivatorAccessor featureFlagActivatorAccessor;
    private final ObjectMapper configuredObjectMapper;

    public FeatureFlagDataProvider(FeatureManager featureManager, FeatureFlagActivatorAccessor featureFlagActivatorAccessor) {
        this.featureManager = featureManager;
        this.featureFlagActivatorAccessor = featureFlagActivatorAccessor;
        this.configuredObjectMapper = new ObjectMapper();
        this.configuredObjectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }

    public Jsonable get() {
        Set registeredFlags = this.featureManager.getRegisteredFlags();
        Set<FeatureFlag> activatedFlags = this.featureFlagActivatorAccessor.getActivatedFlags();
        HashMap featureFlagData = Maps.newHashMap();
        for (FeatureFlag featureFlag : registeredFlags) {
            boolean onByDefault;
            if (featureFlag.isOnByDefault()) {
                if (activatedFlags.contains(featureFlag)) {
                    throw new IllegalStateException("Feature flag can't be 'on by default' and also enabled by activator!");
                }
                onByDefault = true;
            } else {
                onByDefault = activatedFlags.contains(featureFlag);
            }
            featureFlagData.put(featureFlag.featureKey(), onByDefault);
        }
        Set allJiraEnabledFeatures = this.featureManager.getDarkFeatures().getAllEnabledFeatures();
        final HashMap topLevelMap = Maps.newHashMap();
        topLevelMap.put("enabled-feature-keys", allJiraEnabledFeatures);
        topLevelMap.put("feature-flag-states", featureFlagData);
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                FeatureFlagDataProvider.this.configuredObjectMapper.writeValue(writer, (Object)topLevelMap);
            }
        };
    }
}

