/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizHelper;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.ofbiz.core.entity.GenericValue;

class ApplicationEntity {
    static final String ENTITY = "Application";
    static final String APPLICATION_ID = "id";
    static final String NAME = "name";
    static final String LOWER_NAME = "lowerName";
    static final String ACTIVE = "active";
    static final String DESCRIPTION = "description";
    static final String APPLICATION_TYPE = "applicationType";
    static final String CREATED_DATE = "createdDate";
    static final String UPDATED_DATE = "updatedDate";
    static final String CREDENTIAL = "credential";

    private ApplicationEntity() {
    }

    static Map<String, Object> getData(Application application) {
        PrimitiveMap.Builder data = PrimitiveMap.builder();
        data.put(NAME, application.getName());
        data.putCaseInsensitive(LOWER_NAME, application.getName());
        data.put(ACTIVE, application.isActive());
        data.put(DESCRIPTION, application.getDescription());
        data.put(APPLICATION_TYPE, application.getType().name());
        data.put(CREATED_DATE, OfBizHelper.convertToSqlTimestamp(application.getCreatedDate()));
        data.put(UPDATED_DATE, OfBizHelper.convertToSqlTimestamp(application.getUpdatedDate()));
        if (application.getCredential() != null) {
            data.put(CREDENTIAL, application.getCredential().getCredential());
        }
        return data.build();
    }

    static GenericValue setData(Application application, GenericValue gv) {
        gv.set(ACTIVE, (Object)BooleanUtils.toInteger((boolean)application.isActive()));
        gv.set(CREATED_DATE, (Object)OfBizHelper.convertToSqlTimestamp(application.getCreatedDate()));
        gv.set(UPDATED_DATE, (Object)OfBizHelper.convertToSqlTimestamp(application.getUpdatedDate()));
        gv.set(DESCRIPTION, (Object)application.getDescription());
        gv.set(NAME, (Object)application.getName());
        gv.set(LOWER_NAME, (Object)IdentifierUtils.toLowerCase((String)application.getName()));
        gv.set(APPLICATION_TYPE, (Object)application.getType().name());
        gv.set(CREDENTIAL, (Object)application.getCredential().getCredential());
        return gv;
    }
}

