/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.UserNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class DelegatingUserDao
implements ExtendedUserDao {
    DelegatingUserDao() {
    }

    protected abstract ExtendedUserDao delegate();

    @Override
    public boolean useFullCache() {
        return this.delegate().useFullCache();
    }

    @Override
    public boolean useInternedUserValues() {
        return this.delegate().useInternedUserValues();
    }

    @Override
    public long getUniqueUserCount(Set<Long> directoryIds) throws DirectoryNotFoundException {
        return this.delegate().getUniqueUserCount(directoryIds);
    }

    @Override
    public Collection<String> findNamesOfUsersInGroups(Collection<String> groupNames) {
        return this.delegate().findNamesOfUsersInGroups(groupNames);
    }

    @Override
    public Collection<String> getAllAttributeKeys() {
        return this.delegate().getAllAttributeKeys();
    }

    @Override
    public void processUsers(Consumer<? super User> userProcessor) {
        this.delegate().processUsers(userProcessor);
    }

    @Override
    public void flushCache() {
        this.delegate().flushCache();
    }

    public TimestampedUser findByName(long directoryId, String userName) throws com.atlassian.crowd.exception.UserNotFoundException {
        return this.delegate().findByName(directoryId, userName);
    }

    public TimestampedUser findByExternalId(long directoryId, String externalId) throws com.atlassian.crowd.exception.UserNotFoundException {
        return this.delegate().findByExternalId(directoryId, externalId);
    }

    public UserWithAttributes findByNameWithAttributes(long directoryId, String userName) throws com.atlassian.crowd.exception.UserNotFoundException {
        return this.delegate().findByNameWithAttributes(directoryId, userName);
    }

    public PasswordCredential getCredential(long directoryId, String userName) throws com.atlassian.crowd.exception.UserNotFoundException {
        return this.delegate().getCredential(directoryId, userName);
    }

    public List<PasswordCredential> getCredentialHistory(long directoryId, String userName) throws com.atlassian.crowd.exception.UserNotFoundException {
        return this.delegate().getCredentialHistory(directoryId, userName);
    }

    public User add(User user, PasswordCredential credential) throws UserAlreadyExistsException, IllegalArgumentException, DirectoryNotFoundException {
        return this.delegate().add(user, credential);
    }

    public void storeAttributes(User user, Map<String, Set<String>> attributes) throws com.atlassian.crowd.exception.UserNotFoundException {
        this.delegate().storeAttributes(user, attributes);
    }

    public User update(User user) throws com.atlassian.crowd.exception.UserNotFoundException, IllegalArgumentException {
        return this.delegate().update(user);
    }

    public void updateCredential(User user, PasswordCredential credential, int maxCredentialHistory) throws com.atlassian.crowd.exception.UserNotFoundException, IllegalArgumentException {
        this.delegate().updateCredential(user, credential, maxCredentialHistory);
    }

    public User rename(User user, String newName) throws com.atlassian.crowd.exception.UserNotFoundException, UserAlreadyExistsException, IllegalArgumentException {
        return this.delegate().rename(user, newName);
    }

    public void removeAttribute(User user, String attributeName) throws com.atlassian.crowd.exception.UserNotFoundException {
        this.delegate().removeAttribute(user, attributeName);
    }

    public void remove(User user) throws com.atlassian.crowd.exception.UserNotFoundException {
        this.delegate().remove(user);
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        return this.delegate().search(directoryId, query);
    }

    public BatchResult<User> addAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        return this.delegate().addAll(users);
    }

    public BatchResult<String> removeAllUsers(long directoryId, Set<String> userNames) {
        return this.delegate().removeAllUsers(directoryId, userNames);
    }

    public void setAttributeForAllInDirectory(long directoryId, String attrName, String attrValue) {
        this.delegate().setAttributeForAllInDirectory(directoryId, attrName, attrValue);
    }

    @Override
    public OfBizUser findOfBizUser(long directoryId, String userName) throws UserNotFoundException {
        return this.delegate().findOfBizUser(directoryId, userName);
    }

    @Override
    public List<OfBizUser> findAllByNameOrNull(long directoryId, @Nonnull Collection<String> userNames) {
        return this.delegate().findAllByNameOrNull(directoryId, userNames);
    }

    @Override
    @Nullable
    public OfBizUser findByNameOrNull(long directoryId, @Nonnull String userName) {
        return this.delegate().findByNameOrNull(directoryId, userName);
    }

    public Set<String> getAllExternalIds(long directoryId) throws DirectoryNotFoundException {
        return this.delegate().getAllExternalIds(directoryId);
    }

    public long getUserCount(long directoryId) throws DirectoryNotFoundException {
        return this.delegate().getUserCount(directoryId);
    }

    @Override
    @Nullable
    public OfBizUser findById(long internalUserId) {
        return this.delegate().findById(internalUserId);
    }

    @Override
    public boolean isDeletedExternally(long internalUserId) {
        return this.delegate().isDeletedExternally(internalUserId);
    }

    @Override
    public boolean isDeletedExternally(long directoryId, @Nonnull String userName) {
        return this.delegate().isDeletedExternally(directoryId, userName);
    }

    @Override
    public User update(User user, boolean useJiraExtensions) throws UserNotFoundException {
        return this.delegate().update(user, useJiraExtensions);
    }
}

