/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.core.util.StringUtils;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class GroupEntity {
    static final String ENTITY = "Group";
    static final String ID = "id";
    static final String NAME = "groupName";
    static final String LOWER_NAME = "lowerGroupName";
    static final String ACTIVE = "active";
    static final String LOCAL = "local";
    static final String DESCRIPTION = "description";
    static final String LOWER_DESCRIPTION = "lowerDescription";
    static final String CREATED_DATE = "createdDate";
    static final String UPDATED_DATE = "updatedDate";
    static final String DIRECTORY_ID = "directoryId";
    static final String TYPE = "type";
    static final int MAX_DESCRIPTION_LENGTH = 255;
    private static final Map<String, String> FIELD_NAME_TRANSLATION;

    private GroupEntity() {
    }

    static Map<String, Object> getData(Group group, Timestamp updatedDate, Timestamp createdDate, boolean local) {
        PrimitiveMap.Builder data = PrimitiveMap.builder();
        data.put(NAME, group.getName());
        data.putCaseInsensitive(LOWER_NAME, group.getName());
        data.put(ACTIVE, group.isActive());
        String description = GroupEntity.truncateDescriptionIfRequired(group.getDescription());
        data.put(DESCRIPTION, description);
        data.putCaseInsensitive(LOWER_DESCRIPTION, GroupEntity.truncateDescriptionIfRequired(IdentifierUtils.toLowerCase((String)description)));
        data.put(DIRECTORY_ID, group.getDirectoryId());
        data.put(TYPE, group.getType().name());
        if (updatedDate != null) {
            data.put(UPDATED_DATE, updatedDate);
        }
        if (createdDate != null) {
            data.put(CREATED_DATE, createdDate);
        }
        data.put(LOCAL, local);
        return data.build();
    }

    static String getLowercaseFieldNameFor(String fieldName) {
        return FIELD_NAME_TRANSLATION.get(fieldName);
    }

    static boolean isSystemField(String fieldName) {
        return FIELD_NAME_TRANSLATION.containsKey(fieldName);
    }

    static String truncateDescriptionIfRequired(String description) {
        return StringUtils.crop((String)description, (int)255, (String)"");
    }

    static {
        HashMap<String, String> builder = new HashMap<String, String>(16);
        builder.put(ID, null);
        builder.put(NAME, LOWER_NAME);
        builder.put(LOWER_NAME, LOWER_NAME);
        builder.put(DIRECTORY_ID, null);
        builder.put(ACTIVE, null);
        builder.put(LOCAL, null);
        builder.put(DESCRIPTION, LOWER_DESCRIPTION);
        builder.put(LOWER_DESCRIPTION, LOWER_DESCRIPTION);
        builder.put(TYPE, null);
        builder.put(CREATED_DATE, null);
        builder.put(UPDATED_DATE, null);
        builder.put(GroupTermKeys.NAME.getPropertyName(), LOWER_NAME);
        FIELD_NAME_TRANSLATION = Collections.unmodifiableMap(builder);
    }
}

