/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.gadgets.opensocial.spi.Whitelist;
import com.atlassian.jira.bc.whitelist.WhitelistService;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

public class JiraWhitelist
implements Whitelist {
    private final WhitelistService whitelistService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public JiraWhitelist(WhitelistService whitelistService, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.whitelistService = whitelistService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public boolean allows(URI uriRequest) {
        String canonicalBaseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        try {
            URI uri = new URI(uriRequest.normalize().toASCIIString());
            URI baseUri = new URI(canonicalBaseUrl);
            boolean isLocal = StringUtils.equalsIgnoreCase((CharSequence)baseUri.getScheme(), (CharSequence)uri.getScheme()) && StringUtils.equalsIgnoreCase((CharSequence)baseUri.getHost(), (CharSequence)uri.getHost()) && baseUri.getPort() == uri.getPort();
            return isLocal || this.whitelistService.isAllowed(uri);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

