/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class QueryPlanAnalyzer {
    private static String EXPLAIN = "EXPLAIN";
    private static String EXPLAIN_ANALYZE = "EXPLAIN ANALYZE";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String explainStatement(Connection connection, PreparedStatement preparedStatement, boolean analyze) {
        StringBuilder qryBuilder = new StringBuilder();
        if (analyze) {
            qryBuilder.append(EXPLAIN_ANALYZE);
        } else {
            qryBuilder.append(EXPLAIN);
        }
        qryBuilder.append(" ").append(preparedStatement);
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery(qryBuilder.toString());
            String plan = "";
            while (rs.next()) {
                plan = plan + rs.getString(1);
            }
            String string = plan;
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

