/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.diagnostic.connection;

import com.atlassian.diagnostics.internal.platform.monitor.db.DatabaseDiagnosticsCollector;
import com.atlassian.diagnostics.internal.platform.monitor.db.SqlOperation;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.Startable;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginEvent;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.sql.Connection;
import java.sql.SQLException;

@EventComponent
public class DatabaseDiagnosticsCollectorDelegate
implements Startable {
    private static final String DIAGNOSTICS_PLUGIN_KEY = "com.atlassian.jira.diagnostics";
    private ResettableLazyReference<DatabaseDiagnosticsCollector> delegate = Lazy.resettable(() -> {
        try {
            return (DatabaseDiagnosticsCollector)ComponentAccessor.getOSGiComponentInstanceOfType(DatabaseDiagnosticsCollector.class);
        }
        catch (IllegalStateException e) {
            return null;
        }
    });

    public boolean isEnabled() {
        return this.delegate.get() != null;
    }

    public void trackConnection(Connection connection) {
        DatabaseDiagnosticsCollector diagnosticsCollector = (DatabaseDiagnosticsCollector)this.delegate.get();
        if (diagnosticsCollector != null) {
            diagnosticsCollector.trackConnection(connection);
        }
    }

    public void removeTrackedConnection(Connection connection) {
        DatabaseDiagnosticsCollector diagnosticsCollector = (DatabaseDiagnosticsCollector)this.delegate.get();
        if (diagnosticsCollector != null) {
            diagnosticsCollector.removeTrackedConnection(connection);
        }
    }

    public <T> T recordExecutionTime(SqlOperation<T> operation, String sql) throws SQLException {
        DatabaseDiagnosticsCollector diagnosticsCollector = (DatabaseDiagnosticsCollector)this.delegate.get();
        if (diagnosticsCollector != null) {
            return (T)diagnosticsCollector.recordExecutionTime(operation, sql);
        }
        return (T)operation.execute();
    }

    public void start() {
        this.delegate.reset();
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (this.isDiagnosticsPlugin((PluginEvent)event)) {
            this.delegate.reset();
        }
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        if (this.isDiagnosticsPlugin((PluginEvent)event)) {
            this.delegate.reset();
        }
    }

    private boolean isDiagnosticsPlugin(PluginEvent pluginEnabledEvent) {
        return pluginEnabledEvent.getPlugin().getKey().equals(DIAGNOSTICS_PLUGIN_KEY);
    }
}

