/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.diagnostic.connection;

import com.atlassian.jira.diagnostic.connection.DatabaseDiagnosticsCollectorDelegate;
import com.atlassian.jira.ofbiz.sql.StatementWrapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DiagnosticStatement
extends StatementWrapper {
    private final DatabaseDiagnosticsCollectorDelegate databaseDiagnosticsCollector;
    private final List<String> batchQueries;

    DiagnosticStatement(Statement wrappedStatement, DatabaseDiagnosticsCollectorDelegate databaseDiagnosticsCollector) {
        super(wrappedStatement);
        this.databaseDiagnosticsCollector = databaseDiagnosticsCollector;
        this.batchQueries = new ArrayList<String>();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return (Boolean)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.execute(sql), sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return (Boolean)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.execute(sql, autoGeneratedKeys), sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return (Boolean)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.execute(sql, columnIndexes), sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return (Boolean)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.execute(sql, columnNames), sql);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return (ResultSet)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeQuery(sql), sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (Integer)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeUpdate(sql, autoGeneratedKeys), sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (Integer)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeUpdate(sql, columnIndexes), sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (Integer)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeUpdate(sql, columnNames), sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (Integer)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeUpdate(sql), sql);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return (Long)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeUpdate(sql), sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (Long)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeUpdate(sql, autoGeneratedKeys), sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (Long)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeUpdate(sql, columnIndexes), sql);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return (Long)this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeUpdate(sql, columnNames), sql);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        super.addBatch(sql);
        this.batchQueries.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchQueries.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return (int[])this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeBatch(), this.getBatchQuery());
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return (long[])this.databaseDiagnosticsCollector.recordExecutionTime(() -> super.executeLargeBatch(), this.getBatchQuery());
    }

    private String getBatchQuery() {
        return String.join((CharSequence)", ", this.batchQueries);
    }
}

