/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue.commit;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.issue.JiraIssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitJiraIssueEvent;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class OnCommitJiraIssueEventBuilder {
    public static Builder builder(JiraIssueEvent data) {
        return new Builder(data);
    }

    public static Builder builder(OnCommitJiraIssueEvent data) {
        return new Builder(data);
    }

    public static final class Builder {
        private JiraIssueEvent jiraIssueEvent;
        private Option<OnCommitEvent.OnCommitEventTransactionStatus> onCommitEventTransactionStatusOption;
        private Option<OnCommitEvent.OnCommitEventDataReloadStatus> onCommitEventDataReloadStatusOption;

        private Builder(JiraIssueEvent initialData) {
            this.jiraIssueEvent = initialData;
            this.onCommitEventDataReloadStatusOption = Option.none();
            this.onCommitEventTransactionStatusOption = Option.none();
        }

        private Builder(OnCommitJiraIssueEvent initialData) {
            this.jiraIssueEvent = (JiraIssueEvent)initialData.getWrappedEvent();
            this.onCommitEventTransactionStatusOption = Option.option((Object)initialData.getOnCommitEventTransactionStatus());
            this.onCommitEventDataReloadStatusOption = Option.option((Object)initialData.getOnCommitEventDataReloadStatus());
        }

        public Builder setJiraIssueEvent(JiraIssueEvent jiraIssueEvent) {
            this.jiraIssueEvent = jiraIssueEvent;
            return this;
        }

        public Builder setOnCommitEventTransactionStatus(OnCommitEvent.OnCommitEventTransactionStatus onCommitEventTransactionStatus) {
            this.onCommitEventTransactionStatusOption = Option.option((Object)onCommitEventTransactionStatus);
            return this;
        }

        public Builder setOnCommitEventDataReloadStatus(OnCommitEvent.OnCommitEventDataReloadStatus onCommitEventDataReloadStatus) {
            this.onCommitEventDataReloadStatusOption = Option.option((Object)onCommitEventDataReloadStatus);
            return this;
        }

        public OnCommitJiraIssueEvent build() {
            Assertions.notNull((String)"JiraIssueEvent", (Object)this.jiraIssueEvent);
            if (this.onCommitEventTransactionStatusOption.isDefined() && this.onCommitEventDataReloadStatusOption.isDefined()) {
                return new OnCommitJiraIssueEvent(){

                    @Nonnull
                    public JiraIssueEvent getWrappedEvent() {
                        return jiraIssueEvent;
                    }

                    @Nonnull
                    public OnCommitEvent.OnCommitEventDataReloadStatus getOnCommitEventDataReloadStatus() {
                        return (OnCommitEvent.OnCommitEventDataReloadStatus)onCommitEventDataReloadStatusOption.get();
                    }

                    @Nonnull
                    public OnCommitEvent.OnCommitEventTransactionStatus getOnCommitEventTransactionStatus() {
                        return (OnCommitEvent.OnCommitEventTransactionStatus)onCommitEventTransactionStatusOption.get();
                    }
                };
            }
            if (this.onCommitEventDataReloadStatusOption.isDefined()) {
                return new OnCommitJiraIssueEvent(){

                    @Nonnull
                    public JiraIssueEvent getWrappedEvent() {
                        return jiraIssueEvent;
                    }

                    @Nonnull
                    public OnCommitEvent.OnCommitEventDataReloadStatus getOnCommitEventDataReloadStatus() {
                        return (OnCommitEvent.OnCommitEventDataReloadStatus)onCommitEventDataReloadStatusOption.get();
                    }
                };
            }
            if (this.onCommitEventTransactionStatusOption.isDefined()) {
                return new OnCommitJiraIssueEvent(){

                    @Nonnull
                    public JiraIssueEvent getWrappedEvent() {
                        return jiraIssueEvent;
                    }

                    @Nonnull
                    public OnCommitEvent.OnCommitEventTransactionStatus getOnCommitEventTransactionStatus() {
                        return (OnCommitEvent.OnCommitEventTransactionStatus)onCommitEventTransactionStatusOption.get();
                    }
                };
            }
            return new OnCommitJiraIssueEvent(){

                @Nonnull
                public JiraIssueEvent getWrappedEvent() {
                    return jiraIssueEvent;
                }
            };
        }
    }
}

