/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.analytics;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.health.analytics.HealthCheckAnalyticsEvent;
import com.atlassian.jira.health.analytics.HealthCheckAnalyticsEventFactory;
import com.atlassian.jira.startup.mode.StartupMode;
import com.atlassian.jira.startup.mode.StartupModeReference;
import com.atlassian.johnson.event.Event;
import java.net.URL;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultHealthCheckAnalyticsEventFactory
implements HealthCheckAnalyticsEventFactory {
    private final Supplier<Optional<StartupModeReference>> startupModeReference = ComponentAccessor.safeSupplierOf(StartupModeReference.class);

    @Override
    @Nonnull
    public HealthCheckAnalyticsEvent forHealthCheckResult(Event johnsonEvent) {
        return this.createEvent(johnsonEvent, null);
    }

    @Override
    @Nonnull
    public HealthCheckAnalyticsEvent forJohnsonHelpLinkClicked(Event johnsonEvent) {
        URL kbURL = (URL)johnsonEvent.getAttribute((Object)"helpUrl");
        return this.createEvent(johnsonEvent, kbURL);
    }

    private HealthCheckAnalyticsEvent createEvent(Event johnsonEvent, @Nullable URL kbUrl) {
        StartupMode startupMode = this.startupModeReference.get().map(StartupModeReference::get).orElse(StartupMode.UNKNOWN);
        String cause = (String)johnsonEvent.getAttribute((Object)"causeKey");
        String checkId = (String)johnsonEvent.getAttribute((Object)"idKey");
        String eventId = (String)johnsonEvent.getAttribute((Object)"eventKey");
        String eventLevel = johnsonEvent.getLevel().getLevel();
        return new HealthCheckAnalyticsEvent(checkId, startupMode, eventId, eventLevel, cause, kbUrl);
    }
}

