/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.startup.mode.StartupMode;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@EventName(value="health.check.completed")
public class HealthCheckAnalyticsEvent {
    private static final String JIRA_RUN_ID = UUID.randomUUID().toString();
    private final StartupMode startupMode;
    private final String checkId;
    private final String eventId;
    private final String eventLevel;
    private final String cause;
    private final URL kbURL;

    HealthCheckAnalyticsEvent(String checkId, StartupMode startupMode, String eventId, String eventLevel, String cause, @Nullable URL kbURL) {
        this.checkId = Objects.requireNonNull(checkId);
        this.startupMode = Objects.requireNonNull(startupMode);
        this.eventId = Objects.requireNonNull(eventId);
        this.eventLevel = Objects.requireNonNull(eventLevel);
        this.cause = Objects.requireNonNull(cause);
        this.kbURL = kbURL;
    }

    public String getJiraRunId() {
        return JIRA_RUN_ID;
    }

    public String getCheckId() {
        return HealthCheckAnalyticsEvent.toUUID(this.checkId.getBytes());
    }

    public String getCause() {
        return HealthCheckAnalyticsEvent.toUUID(this.cause.getBytes());
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getEventLevel() {
        return this.eventLevel;
    }

    public String getStartupMode() {
        return this.startupMode.toString();
    }

    @Nullable
    public String getKbURL() {
        return this.kbURL == null ? null : HealthCheckAnalyticsEvent.toUUID(this.kbURL.toString().getBytes());
    }

    private static String toUUID(byte[] bytes) {
        return UUID.nameUUIDFromBytes(bytes).toString();
    }
}

