/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.plugin.language.TranslationTransform;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.IteratorEnumeration;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.i18n.I18nTranslationMode;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.jira.web.bean.i18n.TranslationStore;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@Internal
@VisibleForTesting
public class BackingI18n
implements I18nHelper {
    private static final Logger log = LoggerFactory.getLogger(I18nHelper.class);
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final char START_HIGHLIGHT_CHAR = '\ufeff';
    private static final char MIDDLE_HIGHLIGHT_CHAR = '\u26a1';
    private static final char END_HIGHLIGHT_CHAR = '\u2060';
    private final Locale locale;
    private final TranslationStore translationMap;
    private final I18nTranslationMode i18nTranslationMode;
    private final List<TranslationTransform> translationTransforms;
    private final ResourceBundle resourceBundle;
    @ClusterSafe
    private final LoadingCache<String, Set<String>> prefixKeysCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build(CacheLoader.from((Function)new PrefixFunction()));

    BackingI18n(Locale locale, I18nTranslationMode i18nTranslationMode, Iterable<? extends TranslationTransform> translationTransforms, TranslationStore translationStore) {
        this.i18nTranslationMode = (I18nTranslationMode)Assertions.notNull((String)"i18nTranslationMode", (Object)i18nTranslationMode);
        this.locale = (Locale)Assertions.notNull((String)"locale", (Object)locale);
        this.translationTransforms = ImmutableList.copyOf((Iterable)((Iterable)Assertions.notNull((String)"translationTransforms", translationTransforms)));
        this.translationMap = (TranslationStore)Assertions.notNull((String)"translationStore", (Object)translationStore);
        this.resourceBundle = new MapWrappingResourceBundle(this.translationMap);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceBundle getDefaultResourceBundle() {
        return DefaultResourceBundle.getDefaultResourceBundle(this.locale);
    }

    public Set<String> getKeysForPrefix(String prefix) {
        return (Set)this.prefixKeysCache.getUnchecked((Object)prefix);
    }

    @HtmlSafe
    public String getUnescapedText(String key) {
        String value = this.getTranslation(key = BackingI18n.cleanKey(key));
        return value != null ? value : key;
    }

    @HtmlSafe
    public String getUntransformedRawText(String key) {
        String rawMessage = this.translationMap.get(key = BackingI18n.cleanKey(key));
        if (rawMessage != null) {
            return rawMessage;
        }
        return key;
    }

    public boolean isKeyDefined(String key) {
        return this.translationMap.containsKey(BackingI18n.cleanKey(key));
    }

    @HtmlSafe
    public String getText(String key) {
        return this.formatI18nMsg(key, new Object[0]);
    }

    @HtmlSafe
    public String getText(String key, String value1) {
        return this.formatI18nMsg(key, value1);
    }

    @HtmlSafe
    public String getText(String key, String value1, String value2) {
        return this.formatI18nMsg(key, value1, value2);
    }

    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3) {
        return this.formatI18nMsg(key, value1, value2, value3);
    }

    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3) {
        return this.formatI18nMsg(key, value1, value2, value3);
    }

    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3, String value4) {
        return this.formatI18nMsg(key, value1, value2, value3, value4);
    }

    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
        return this.formatI18nMsg(key, value1, value2, value3, value4);
    }

    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5);
    }

    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6);
    }

    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7);
    }

    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7);
    }

    @HtmlSafe
    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    @HtmlSafe
    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
        return this.formatI18nMsg(key, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    @HtmlSafe
    public String getText(String key, Object parameters) {
        Object[] substitutionParameters = parameters instanceof Object[] ? (Object[])parameters : (parameters instanceof Iterable ? Iterables.toArray((Iterable)((Iterable)parameters), Object.class) : (parameters == null ? EMPTY_ARRAY : new Object[]{parameters}));
        return this.formatI18nMsg(key, substitutionParameters);
    }

    private static String cleanKey(String key) {
        return key != null && key.length() >= 2 && key.charAt(0) == '\'' && key.charAt(key.length() - 1) == '\'' ? key.substring(1, key.length() - 1) : key;
    }

    private String formatI18nMsg(String key, Object ... substitutionParameters) {
        MessageFormat mf;
        String rawMessage = this.getTranslation(key = BackingI18n.cleanKey(key));
        if (rawMessage == null) {
            if (log.isDebugEnabled()) {
                log.debug("Could not find i18n key: " + key);
            }
            return this.hilightMsg(key, key, key);
        }
        try {
            mf = new MessageFormat(rawMessage, this.locale);
        }
        catch (IllegalArgumentException e) {
            log.error("Error rendering '" + rawMessage + "': " + e.getMessage(), (Throwable)e);
            throw e;
        }
        String formattedMsg = mf.format(substitutionParameters == null ? EMPTY_ARRAY : substitutionParameters);
        return this.hilightMsg(key, rawMessage, formattedMsg);
    }

    private String getTranslation(String key) {
        String rawMessage = this.translationMap.get(key);
        if (rawMessage != null) {
            rawMessage = this.processTranslationTransforms(key, rawMessage);
        }
        return rawMessage;
    }

    private String processTranslationTransforms(String key, String rawMessage) {
        String result = rawMessage;
        for (TranslationTransform translationTransform : this.translationTransforms) {
            result = translationTransform.apply(this.locale, key, result);
        }
        return result;
    }

    private String hilightMsg(String key, String rawMessage, String formattedMsg) {
        if (this.i18nTranslationMode.isTranslationMode()) {
            if (formattedMsg.equals(rawMessage)) {
                return String.format("%c%s%c%s%c%c", Character.valueOf('\ufeff'), formattedMsg, Character.valueOf('\u26a1'), key, Character.valueOf('\u26a1'), Character.valueOf('\u2060'));
            }
            return String.format("%c%s%c%s%c%s%c", Character.valueOf('\ufeff'), formattedMsg, Character.valueOf('\u26a1'), key, Character.valueOf('\u26a1'), rawMessage, Character.valueOf('\u2060'));
        }
        return formattedMsg;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private static class MapWrappingResourceBundle
    extends ResourceBundle {
        private final TranslationStore translationMap;

        public MapWrappingResourceBundle(TranslationStore translationMap) {
            Validate.notNull((Object)translationMap);
            this.translationMap = translationMap;
        }

        @Override
        public Enumeration<String> getKeys() {
            return IteratorEnumeration.fromIterable(this.translationMap.keys());
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.translationMap.get(key);
        }
    }

    private class PrefixFunction
    implements Function<String, Set<String>> {
        private PrefixFunction() {
        }

        public Set<String> apply(String prefix) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String key : BackingI18n.this.translationMap.keys()) {
                if (!key.startsWith(prefix)) continue;
                builder.add((Object)key.intern());
            }
            return builder.build();
        }
    }
}

