/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.concurrent.ResettableLazyReference;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.i18n.BackingI18nFactory;
import com.atlassian.jira.i18n.ResourceBundleCacheCleaner;
import com.atlassian.jira.plugin.JiraPluginCacheResetEvent;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.plugin.language.TranslationTransform;
import com.atlassian.jira.plugin.language.TranslationTransformModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.util.ModuleDescriptorPredicates;
import com.atlassian.jira.plugin.util.PluginsTracker;
import com.atlassian.jira.plugin.util.SimplePluginsTracker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserLocaleStore;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.jira.web.util.JiraLocaleUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingI18nFactory
implements I18nHelper.BeanFactory,
InitializingComponent,
Startable {
    private static final Logger log = LoggerFactory.getLogger(CachingI18nFactory.class);
    private static final String LOG_PREFIX = "[i18n-caching-factory] ";
    static final String I18N_RESOURCE_TYPE = "i18n";
    @ClusterSafe
    private final LoadingCache<Locale, I18nHelper> cache;
    private final JiraLocaleUtils jiraLocaleUtils;
    private final UserLocaleStore userLocaleStore;
    private final com.google.common.base.Supplier<PluginAccessor> pluginAccessorSupplier;
    private final EventPublisher eventPublisher;
    private final AtomicBoolean jiraStarted = new AtomicBoolean(false);
    private final ResourceBundleCacheCleaner resourceBundleCacheCleaner;
    @ClusterSafe(value="Driven by plugin state, which is kept in sync across the cluster")
    private final ResettableLazyReference<PluginsTracker> involvedPluginsTracker = new ResettableLazyReference();
    @ClusterSafe(value="Driven by plugin state, which is kept in sync across the cluster")
    private final ResettableLazyReference<List<TranslationTransform>> translationTransformsRef = new ResettableLazyReference();

    public CachingI18nFactory(JiraLocaleUtils jiraLocaleUtils, EventPublisher eventPublisher, BackingI18nFactory i18nBackingFactory, UserLocaleStore userLocaleStore, ComponentLocator locator, ResourceBundleCacheCleaner resourceBundleCacheCleaner) {
        this.jiraLocaleUtils = jiraLocaleUtils;
        this.eventPublisher = eventPublisher;
        this.userLocaleStore = userLocaleStore;
        this.pluginAccessorSupplier = locator.getComponentSupplier(PluginAccessor.class);
        this.resourceBundleCacheCleaner = resourceBundleCacheCleaner;
        this.cache = this.buildCache(i18nBackingFactory);
        log.info("[i18n-caching-factory] Created");
    }

    private LoadingCache<Locale, I18nHelper> buildCache(BackingI18nFactory i18nBackingFactory) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        return cacheBuilder.build(CacheLoader.from(locale -> {
            I18nHelper i18nHelper = i18nBackingFactory.create((Locale)locale, this.translationTransforms());
            if (this.jiraStarted.get()) {
                this.resourceBundleCacheCleaner.cleanPluginBundlesFromResourceBundleCache();
            }
            return i18nHelper;
        }));
    }

    public void start() {
        log.info("[i18n-caching-factory] Starting");
        this.jiraStarted.set(true);
        this.clearCaches();
        this.resourceBundleCacheCleaner.cleanPluginBundlesFromResourceBundleCache();
        new GoogleCacheInstruments("i18n." + this.getClass().getSimpleName()).addCache((Cache)this.cache).install();
    }

    @Override
    public void afterInstantiation() {
        log.info("[i18n-caching-factory] Registering for events");
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onJiraPluginCacheResetEvent(JiraPluginCacheResetEvent event) {
        if (event.hasAnyEventOfTypeMatching(PluginEnabledEvent.class, pluginEnabledEvent -> this.affectsI18n().test(pluginEnabledEvent.getPlugin())) || event.hasAnyEventOfTypeMatching(PluginModuleDisabledEvent.class, pluginModuleDisabledEvent -> this.jiraStarted.get() || this.getPluginsTracker().isPluginInvolved(pluginModuleDisabledEvent.getModule())) || event.hasAnyEventOfTypeMatching(PluginModuleEnabledEvent.class, pluginModuleEnabledEvent -> this.jiraStarted.get() && this.affectsI18n().test(pluginModuleEnabledEvent.getModule().getPlugin())) || event.hasAnyEventOfTypeMatching(PluginRefreshedEvent.class, pluginRefreshedEvent -> this.getPluginsTracker().isPluginInvolved(pluginRefreshedEvent.getPlugin()))) {
            log.debug("[i18n-caching-factory] Clearing caches on: {}", (Object)event);
            this.clearCaches();
        } else {
            log.debug("[i18n-caching-factory] NOT clearing caches on: {}", (Object)event);
        }
    }

    private Predicate<Plugin> affectsI18n() {
        return ModuleDescriptorPredicates.isPluginWithModuleDescriptor(LanguageModuleDescriptor.class).or(ModuleDescriptorPredicates.isPluginWithResourceType(I18N_RESOURCE_TYPE)).or(ModuleDescriptorPredicates.isPluginWithModuleDescriptor(TranslationTransformModuleDescriptor.class));
    }

    private void clearCaches() {
        this.involvedPluginsTracker.reset();
        this.cache.invalidateAll();
        this.jiraLocaleUtils.resetInstalledLocales();
        this.translationTransformsRef.reset();
    }

    @Nonnull
    public I18nHelper getInstance(Locale locale) {
        if (DefaultResourceBundle.isDefaultResourceBundleStale(locale)) {
            this.clearCaches();
        }
        try {
            return (I18nHelper)this.cache.getUnchecked((Object)locale);
        }
        catch (UncheckedExecutionException ex) {
            throw this.unwind((RuntimeException)((Object)ex));
        }
    }

    @Nonnull
    public I18nHelper getInstance(ApplicationUser user) {
        return this.getInstance(this.userLocaleStore.getLocale(user));
    }

    private RuntimeException unwind(RuntimeException re) {
        Throwable cause = re.getCause();
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        return re;
    }

    public String getStateHashCode() {
        return this.getPluginsTracker().getStateHashCode();
    }

    private PluginsTracker getPluginsTracker() {
        return this.involvedPluginsTracker.getOrCreate((Supplier<PluginsTracker>)((Supplier)this::createPluginsTracker));
    }

    private PluginsTracker createPluginsTracker() {
        PluginAccessor pluginAccessor = (PluginAccessor)this.pluginAccessorSupplier.get();
        ImmutableList allInvolvedPlugins = (ImmutableList)pluginAccessor.getEnabledPlugins().stream().filter(this.affectsI18n()).collect(CollectorsUtil.toImmutableList());
        return new SimplePluginsTracker((List<Plugin>)allInvolvedPlugins);
    }

    private Iterable<? extends TranslationTransform> translationTransforms() {
        return this.translationTransformsRef.getOrCreate((Supplier<List<TranslationTransform>>)((Supplier)this::createTranslationTransforms));
    }

    private List<TranslationTransform> createTranslationTransforms() {
        Stream sortedDescriptors = ((PluginAccessor)this.pluginAccessorSupplier.get()).getEnabledModuleDescriptorsByClass(TranslationTransformModuleDescriptor.class).stream().sorted(ModuleDescriptorComparator.COMPARATOR);
        return (List)sortedDescriptors.map(ModuleDescriptor::getModule).collect(CollectorsUtil.toImmutableList());
    }
}

