/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.util.JiraHome;
import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsoleteIndexCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(ObsoleteIndexCleaner.class);
    static final String CLEAR_OBSOLETE_INDEX_DURING_STARTUP_DISABLED_FEATURE_FLAG = "com.atlassian.jira.index.obsolete.cleaner";
    private final JiraHome jiraHome;
    private final FeatureFlag disableCleanObsoleteIndexDuringStartupFlag;
    private final FeatureManager featureManager;

    public ObsoleteIndexCleaner(JiraHome jiraHome, FeatureManager featureManager) {
        this.jiraHome = jiraHome;
        this.featureManager = featureManager;
        this.disableCleanObsoleteIndexDuringStartupFlag = FeatureFlag.featureFlag((String)CLEAR_OBSOLETE_INDEX_DURING_STARTUP_DISABLED_FEATURE_FLAG);
    }

    public void deleteObsoleteIndexes() {
        if (this.featureManager.isEnabled(this.disableCleanObsoleteIndexDuringStartupFlag)) {
            LOG.debug("Obsolete Index cleaner is disabled");
            return;
        }
        this.deleteIndex();
    }

    private void deleteIndex() {
        this.forceDelete(this.jiraHome.getCachesDirectory().toPath().resolve("indexes"));
    }

    private void forceDelete(Path oldIndex) {
        try {
            LOG.info("Purging {} - index file not compatible with Lucene 7.x", (Object)oldIndex);
            FileUtils.deleteDirectory((File)oldIndex.toFile());
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to remove index file: %s", oldIndex), (Throwable)e);
        }
    }
}

