/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.index.ha.IndexesRestoredEvent;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.TemporaryFilesProvider;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexReader;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexCopyService
implements IndexCopyService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexCopyService.class);
    public static final String BACKUP_INDEX_DONE = "Index Backed Up";
    public static final String BACKUP_INDEX = "Backup Index";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndexCopyService.class);
    private static final String INDEX_BACKUP_SEQUENCE = "IndexBackupSequence";
    private final MessageConsumer messageConsumer;

    public DefaultIndexCopyService(JiraHome jiraHome, IndexUtils indexUtils, MessageHandlerService messageHandlerService, EventPublisher eventPublisher, IndexRecoveryManager indexRecoveryManager, DelegatorInterface delegatorInterface, I18nHelper i18n, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore, IssueIndexManager issueManager) {
        String sharedIndexPath = PathUtils.joinPaths((String[])new String[]{jiraHome.getHome().getAbsolutePath(), "caches"});
        this.messageConsumer = new MessageConsumer(indexUtils, indexRecoveryManager, delegatorInterface, messageHandlerService, sharedIndexPath, eventPublisher, ofBizNodeIndexOperationStore, issueManager);
        messageHandlerService.registerListener(BACKUP_INDEX, this.messageConsumer);
        messageHandlerService.registerListener(BACKUP_INDEX_DONE, this.messageConsumer);
    }

    @Override
    public String backupIndex(String requestingNode) {
        return this.backupIndex(requestingNode, null);
    }

    @Override
    public String backupIndex(String requestingNode, TemporaryFilesProvider temporaryFilesProvider) {
        return this.messageConsumer.backupIndex(requestingNode, temporaryFilesProvider);
    }

    @Override
    public void restoreIndex(String filePath) {
        this.messageConsumer.restoreIndex(filePath);
    }

    @VisibleForTesting
    String copyIndex(String destinationPath, Long id) {
        return this.messageConsumer.copyIndex(destinationPath, id, null);
    }

    private static class MessageConsumer
    implements ClusterMessageConsumer {
        private static final int MAX_SNAPSHOTS = 3;
        private final IndexUtils indexUtils;
        private final IndexRecoveryManager indexRecoveryManager;
        private final DelegatorInterface delegatorInterface;
        private final MessageHandlerService messageHandlerService;
        private final String sharedIndexPath;
        private final EventPublisher eventPublisher;
        private final OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore;
        private final IssueIndexManager issueManager;
        private final ComponentReference<ClusterManager> clusterManagerRef = ComponentAccessor.getComponentReference(ClusterManager.class);

        public MessageConsumer(IndexUtils indexUtils, IndexRecoveryManager indexRecoveryManager, DelegatorInterface delegatorInterface, MessageHandlerService messageHandlerService, String sharedIndexPath, EventPublisher eventPublisher, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore, IssueIndexManager issueManager) {
            this.indexUtils = indexUtils;
            this.indexRecoveryManager = indexRecoveryManager;
            this.delegatorInterface = delegatorInterface;
            this.messageHandlerService = messageHandlerService;
            this.sharedIndexPath = sharedIndexPath;
            this.eventPublisher = eventPublisher;
            this.ofBizNodeIndexOperationStore = ofBizNodeIndexOperationStore;
            this.issueManager = issueManager;
        }

        public String backupIndex(String requestingNode) {
            return this.backupIndex(requestingNode, null);
        }

        public String backupIndex(String requestingNode, TemporaryFilesProvider temporaryFilesProvider) {
            if (!((ClusterManager)this.clusterManagerRef.get()).isClustered()) {
                throw new UnsupportedOperationException("This method should be called in DC configuration only");
            }
            String nodeId = ((ClusterManager)this.clusterManagerRef.get()).getNodeId();
            LOG.info("Index backup started. Requesting node: {}, currentNode: {}", (Object)requestingNode, (Object)nodeId);
            Long latestOperation = this.ofBizNodeIndexOperationStore.getLatestOperation(nodeId);
            if (latestOperation == null) {
                LOG.warn("Index backup failed - latest index operation not found. Requesting node: {}, currentNode: {}", (Object)requestingNode, (Object)nodeId);
                return null;
            }
            Long backupId = this.delegatorInterface.getNextSeqId(DefaultIndexCopyService.INDEX_BACKUP_SEQUENCE);
            String backupFileName = this.copyIndex(this.sharedIndexPath, backupId, temporaryFilesProvider);
            if (!requestingNode.equals(nodeId)) {
                log.info("Sending message: \"{}\":{} - notification that current node: {} created an index snapshot which can be restored on requesting node: {}", new Object[]{DefaultIndexCopyService.BACKUP_INDEX_DONE, backupFileName, nodeId, requestingNode});
                this.messageHandlerService.sendMessage(requestingNode, new Message(DefaultIndexCopyService.BACKUP_INDEX_DONE, backupFileName));
            } else {
                log.debug("Not sending message: {} to itself on node: {}", (Object)DefaultIndexCopyService.BACKUP_INDEX_DONE, (Object)nodeId);
            }
            LOG.info("Index backup complete. Snapshot file: {}", (Object)backupFileName);
            return backupFileName;
        }

        @VisibleForTesting
        String copyIndex(String destinationPath, Long id, @Nullable TemporaryFilesProvider temporaryFilesProvider) {
            return this.indexUtils.performBackupOperations(destinationPath, id.toString(), 3, null, temporaryFilesProvider);
        }

        public void restoreIndex(String fileName) {
            if (((ClusterManager)this.clusterManagerRef.get()).isClustered()) {
                LOG.info("Index restore started. Total {} issues on instance before loading Snapshot file: {}", (Object)this.getNumberOfIssues(), (Object)fileName);
                File backupFile = new File(this.sharedIndexPath, fileName);
                try {
                    this.indexRecoveryManager.recoverIndexFromBackup(backupFile, TaskProgressSink.NULL_SINK);
                }
                catch (IndexException e) {
                    throw new RuntimeException(e);
                }
                this.eventPublisher.publish((Object)IndexesRestoredEvent.INSTANCE);
                LOG.info("Index restore complete. Total {} issues on instance", (Object)this.getNumberOfIssues());
            }
        }

        private String getNumberOfIssues() {
            return Optional.of(this.issueManager).map(IssueIndexManager::getIssueSearcher).map(rec$ -> ((ManagedIndexSearcher)rec$).getIndexReader()).map(IndexReader::numDocs).map(Long::toString).orElse("[Unknown]");
        }

        public void receive(String channel, String message, String senderId) {
            if (channel.equals(DefaultIndexCopyService.BACKUP_INDEX)) {
                log.info("Received message: \"{}\" - request to create index snapshot from node: {} on current node: {}", new Object[]{channel, senderId, ((ClusterManager)this.clusterManagerRef.get()).getNodeId()});
                this.backupIndex(senderId);
            } else if (channel.equals(DefaultIndexCopyService.BACKUP_INDEX_DONE)) {
                log.info("Received message: \"{}\" - notification that node: {} created an index snapshot which can be restored on current node: {}", new Object[]{channel, senderId, ((ClusterManager)this.clusterManagerRef.get()).getNodeId()});
                this.restoreIndex(message);
            }
        }
    }
}

