/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.index.IssueIndexHelper;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.NullAwareIssueIdsIssueIterable;
import com.atlassian.jira.index.ha.ReindexMetadata;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.util.FieldHitCollector;
import com.atlassian.jira.issue.util.IssueObjectIssuesIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.startup.ThreadDumper;
import com.atlassian.jira.task.CompositeProgressSink;
import com.atlassian.jira.task.LoggingProgressSink;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CountingEnclosedIterable;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.compression.ArchiveUtils;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.index.IndexingCounterManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIndexRecoveryManager
implements IndexRecoveryManager {
    private static final Logger LOG = Logger.getLogger(DefaultIndexRecoveryManager.class);
    private static final int DELETE_OLD_INDEXES_MAX_RETRIES = 3;
    private final SearchProvider searchProvider;
    private final SearchService searchService;
    private final OfBizDelegator delegator;
    private final IssueBatcherFactory issueBatcherFactory;
    private final IssueManager issueManager;
    private final IssueIndexer issueIndexer;
    private final IndexLifecycleManager indexLifecycleManager;
    private final IndexPathManager indexPathManager;
    private final IssueFactory issueFactory;
    private final SharedEntityIndexManager sharedEntityIndexManager;
    private final IndexingCounterManager indexingCounterManager;
    private final IssueIndexManager indexManager;
    private final AtomicBoolean recoveryInProgress;
    private final ThreadDumper threadDumper;

    public DefaultIndexRecoveryManager(SearchProvider searchProvider, SearchService searchService, OfBizDelegator delegator, IssueBatcherFactory issueBatcherFactory, IssueManager issueManager, IssueIndexer issueIndexer, IndexLifecycleManager indexLifecycleManager, IndexPathManager indexPathManager, IssueFactory issueFactory, SharedEntityIndexManager sharedEntityIndexManager, IndexingCounterManager indexingCounterManager, IssueIndexManager indexManager) {
        this.searchProvider = searchProvider;
        this.searchService = searchService;
        this.delegator = delegator;
        this.issueBatcherFactory = issueBatcherFactory;
        this.issueManager = issueManager;
        this.issueIndexer = issueIndexer;
        this.indexLifecycleManager = indexLifecycleManager;
        this.indexPathManager = indexPathManager;
        this.issueFactory = issueFactory;
        this.sharedEntityIndexManager = sharedEntityIndexManager;
        this.indexingCounterManager = indexingCounterManager;
        this.indexManager = indexManager;
        this.recoveryInProgress = new AtomicBoolean(false);
        this.threadDumper = new ThreadDumper(0L);
    }

    @Override
    public IndexCommandResult recoverIndexFromBackup(File recoveryFile, TaskProgressSink taskProgressSink) throws IndexException {
        File workDir = new File(this.indexPathManager.getIndexRootPath(), "JIRAIndexRestore");
        if (!this.recoveryInProgress.compareAndSet(false, true)) {
            throw new IndexException("Index recovery already in progress");
        }
        try {
            ArchiveUtils.decompress(recoveryFile, workDir);
            this.validateIssueIndex(workDir);
            CompositeProgressSink compositeSink = new CompositeProgressSink(taskProgressSink, new LoggingProgressSink(LOG, "{1} search indexes - {0}% complete... {2}", 1));
            long startTime = System.currentTimeMillis();
            ReplaceIndexRunner runner = new ReplaceIndexRunner(workDir, this.indexLifecycleManager, this.indexPathManager);
            compositeSink.makeProgress(1L, "Restoring", "Replacing indexes");
            if (!this.indexManager.withReindexLock(JiraThreadLocalUtils.wrap(runner))) {
                throw new IndexException("Failed to acquire reindex lock");
            }
            compositeSink.makeProgress(20L, "Restoring", "Restored index backup");
            if (runner.getDateRange() != null) {
                try {
                    this.reindexIssuesIn(runner.getDateRange(), compositeSink);
                    compositeSink.makeProgress(80L, "Recovering", "Recovered issue index");
                }
                catch (IndexException | SearchException e) {
                    throw new RuntimeException(e);
                }
            } else {
                LOG.warn((Object)"The duration of time where indices will be missing could not be calculated.  Any changes to issues made after the index being restored will not be added to the new index! You can run a background reindex to add missing issue changes to the index.");
            }
            this.sharedEntityIndexManager.reIndexAll(Contexts.nullContext());
            this.indexingCounterManager.incrementValue();
            compositeSink.makeProgress(100L, "Recovering", "Recovered all indexes");
            IndexCommandResult indexCommandResult = new IndexCommandResult(System.currentTimeMillis() - startTime);
            return indexCommandResult;
        }
        catch (IOException e) {
            throw new IndexException((Exception)e);
        }
        finally {
            FileUtils.deleteQuietly((File)workDir);
            this.recoveryInProgress.set(false);
        }
    }

    private void validateIssueIndex(File workDir) throws IOException, IndexFormatTooOldException {
        int basePathLength = this.indexPathManager.getIndexRootPath().length();
        String issuesSubdirectory = this.indexPathManager.getIssueIndexPath().substring(basePathLength + 1);
        try (FSDirectory issuesDirectory = FSDirectory.open((Path)workDir.toPath().resolve(issuesSubdirectory));
             DirectoryReader issuesReader = DirectoryReader.open((Directory)issuesDirectory);){
            int numDocs = issuesReader.numDocs();
            LOG.info((Object)("Restoring index with " + numDocs + " issues"));
        }
    }

    @Override
    public void reindexIssuesIn(DateUtils.DateRange range, TaskProgressSink taskProgressSink) throws IndexException, SearchException {
        if (range.startDate.before(range.endDate)) {
            this.reindexUsingDatabaseLatest(range);
        } else if (range.startDate.after(range.endDate)) {
            this.reindexUsingLucene(range);
        }
        taskProgressSink.makeProgress(60L, "Recovering", "Recovered added and updated issues");
        this.deIndexDeletedIssues();
        taskProgressSink.makeProgress(80L, "Recovering", "Cleaned removed issues");
    }

    private void reindexUsingDatabaseLatest(DateUtils.DateRange range) {
        LOG.info((Object)String.format("Re-indexing issues from: %s to: %s ...", range.startDate, range.endDate));
        EntityExpr ge = new EntityExpr("updated", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)new Timestamp(range.startDate.getTime()));
        EntityExpr le = new EntityExpr("updated", EntityOperator.LESS_THAN_EQUAL_TO, (Object)new Timestamp(range.endDate.getTime()));
        EntityConditionList condition = new EntityConditionList(Arrays.asList(ge, le), EntityOperator.AND);
        Context context = Contexts.nullContext();
        IssuesBatcher batches = this.issueBatcherFactory.getBatcher((EntityCondition)condition);
        int count = 0;
        for (IssuesIterable batch : batches) {
            CountingEnclosedIterable<Issue> countingBatch = new CountingEnclosedIterable<Issue>((EnclosedIterable<Issue>)batch);
            this.issueIndexer.reindexIssues(countingBatch, context, IssueIndexingParams.INDEX_ALL, false);
            count += countingBatch.getCountConsumed();
        }
        LOG.info((Object)String.format("Done re-indexing: %d issues from: %s to: %s.", count, range.startDate, range.endDate));
    }

    private void reindexUsingLucene(DateUtils.DateRange range) throws SearchException {
        FieldHitCollector collector = new FieldHitCollector("issue_id");
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        queryBuilder.where().addDateRangeCondition("updated", range.endDate, range.startDate);
        this.searchProvider.search(SearchQuery.create((Query)queryBuilder.buildQuery(), null).overrideSecurity(true), (Collector)collector);
        Iterable issueIds = Iterables.transform(collector.getValues(), Long::valueOf);
        NullAwareIssueIdsIssueIterable batch = new NullAwareIssueIdsIssueIterable(issueIds, this.issueManager);
        this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batch, Contexts.nullContext(), IssueIndexingParams.INDEX_ALL, false);
    }

    private void deIndexDeletedIssues() throws SearchException {
        IssueIndexHelper issueIndexHelper = new IssueIndexHelper(this.issueManager, this.issueIndexer, this.issueFactory);
        long[] indexIssueIds = issueIndexHelper.getAllIssueIds();
        Set<Long> dbIssueIds = Select.columns("id").from("Issue").runWith(this.delegator).consumeWith(this.createIssueIdsCollector(indexIssueIds.length));
        ArrayList<MutableIssue> deleted = new ArrayList<MutableIssue>();
        long[] lArray = indexIssueIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long id = lArray[i];
            if (dbIssueIds.contains(id)) continue;
            GenericValue gv = this.delegator.makeValue("Issue", (Map)new FieldMap("id", (Object)id));
            deleted.add(this.issueFactory.getIssue(gv));
        }
        if (!deleted.isEmpty()) {
            IssueObjectIssuesIterable issues = new IssueObjectIssuesIterable(deleted);
            this.issueIndexer.deindexIssues((EnclosedIterable<Issue>)issues, Contexts.nullContext());
        }
    }

    private EntityListConsumer<GenericValue, Set<Long>> createIssueIdsCollector(final int size) {
        return new EntityListConsumer<GenericValue, Set<Long>>(){
            private final Set<Long> issueIds;
            {
                this.issueIds = Sets.newHashSetWithExpectedSize((int)size);
            }

            @Override
            public void consume(GenericValue entity) {
                this.issueIds.add(entity.getLong("id"));
            }

            @Override
            public Set<Long> result() {
                return this.issueIds;
            }
        };
    }

    @Override
    public DateUtils.DateRange getDurationToRecover() {
        Date latestIndexDate = this.getLatestIndexDate(null);
        Date latestDbDate = this.getLatestDbDate();
        if (latestDbDate == null || latestIndexDate == null) {
            LOG.debug((Object)String.format("Failed to find duration to recover. Latest index date: {%s}, Latest DB date: {%s}", latestIndexDate, latestDbDate));
            return null;
        }
        LOG.info((Object)String.format("Latest index date: {%1$tF %1$tT}, Latest DB date: {%2$tF %2$tT}", latestIndexDate, latestDbDate));
        return new DateUtils.DateRange(latestIndexDate, latestDbDate);
    }

    private Date getLatestIndexDate(ApplicationUser user) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        queryBuilder.orderBy().updatedDate(SortOrder.DESC);
        try {
            PagerFilter filter = new PagerFilter(0, 1);
            Query query = queryBuilder.buildQuery();
            LOG.trace((Object)String.format("Getting latest index date from index itself using JQL: '{%s}'", query));
            List issues = this.searchService.searchOverrideSecurity(user, query, filter).getResults();
            LOG.debug((Object)String.format("Getting latest index date from index itself - {%d} results", issues.size()));
            if (issues.size() > 0) {
                Timestamp updated = ((Issue)issues.get(0)).getUpdated();
                LOG.debug((Object)String.format("Latest issue in index updated at: {%s}", updated));
                return updated;
            }
        }
        catch (SearchException e) {
            LOG.error((Object)"Error searching for issues", (Throwable)e);
        }
        return null;
    }

    private Date getLatestDbDate() {
        Date result;
        LOG.trace((Object)"Getting latest db date");
        GenericValue lastUpdatedIssueGV = (GenericValue)Select.columns("id", "updated").from("Issue").orderBy("updated DESC").limit(1).runWith(this.delegator).singleValue();
        if (lastUpdatedIssueGV == null) {
            result = null;
            LOG.debug((Object)"Getting latest db date - 0 results");
        } else {
            result = new Date(lastUpdatedIssueGV.getTimestamp("updated").getTime());
            LOG.debug((Object)String.format("Latest issue in db updated: {%s}", result));
        }
        return result;
    }

    public int size() {
        return 100;
    }

    public boolean isEmpty() {
        return false;
    }

    private class ReplaceIndexRunner
    implements Runnable {
        private final File workDir;
        private final IndexLifecycleManager indexLifecycleManager;
        private final IndexPathManager indexPathManager;
        private DateUtils.DateRange range;

        ReplaceIndexRunner(File workDir, IndexLifecycleManager indexLifecycleManager, IndexPathManager indexPathManager) {
            this.workDir = workDir;
            this.indexLifecycleManager = indexLifecycleManager;
            this.indexPathManager = indexPathManager;
            this.range = null;
        }

        @Override
        public void run() {
            this.indexLifecycleManager.deactivate();
            this.removeIndexes();
            try {
                this.replaceIndexes(this.workDir);
            }
            finally {
                this.indexLifecycleManager.shutdown();
                this.indexLifecycleManager.activate(Contexts.nullContext(), false);
            }
            this.range = this.calculateDurationToRecover();
        }

        private DateUtils.DateRange calculateDurationToRecover() {
            DateUtils.DateRange dateRange = null;
            try {
                ReindexMetadata metadata = new ReindexMetadata(this.workDir);
                Date startTime = metadata.getIndexStartTime();
                LOG.debug((Object)String.format("Checking reindex metadata for a startTime; found {%s}", startTime));
                if (startTime != null) {
                    Date latestDbDate = DefaultIndexRecoveryManager.this.getLatestDbDate();
                    LOG.debug((Object)String.format("Checking DB for latest updated issue; found {%s}", latestDbDate));
                    if (latestDbDate != null) {
                        dateRange = new DateUtils.DateRange(startTime, latestDbDate);
                        LOG.info((Object)String.format("Re-index start time: {%1$tF %1$tT.%1$tL}, Latest DB date: {%2$tF %2$tT.%2$tL}", startTime, latestDbDate));
                    }
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Cannot calculate recovery duration", (Throwable)e);
            }
            if (dateRange == null) {
                LOG.debug((Object)"Could not determine date range by checking index; falling back to comparing latest index date with latest db date");
                dateRange = DefaultIndexRecoveryManager.this.getDurationToRecover();
            }
            if (dateRange == null) {
                LOG.debug((Object)"Could not calculate the duration of time where indices will be missing!");
            }
            return dateRange;
        }

        public DateUtils.DateRange getDateRange() {
            return this.range;
        }

        private void removeIndexes() {
            IssueIndexer indexIssuer = (IssueIndexer)ComponentAccessor.getComponent(IssueIndexer.class);
            SharedEntityIndexer sharedEntityIndexer = (SharedEntityIndexer)ComponentAccessor.getComponent(SharedEntityIndexer.class);
            indexIssuer.deleteIndexes();
            sharedEntityIndexer.clear(SearchRequest.ENTITY_TYPE);
            sharedEntityIndexer.clear(PortalPage.ENTITY_TYPE);
        }

        private void replaceIndexes(File workDir) {
            File indexDirectory = new File(this.indexPathManager.getIndexRootPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getSharedEntityIndexPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getWorklogIndexPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getChangeHistoryIndexPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getCommentIndexPath());
            this.cleanDirectoryWithRetries(this.indexPathManager.getIssueIndexPath());
            if (!indexDirectory.exists()) {
                indexDirectory.mkdirs();
            }
            this.moveIndexFiles(new File(workDir, "entities"), indexDirectory);
            this.moveIndexFiles(new File(workDir, "worklogs"), indexDirectory);
            this.moveIndexFiles(new File(workDir, "changes"), indexDirectory);
            this.moveIndexFiles(new File(workDir, "comments"), indexDirectory);
            this.moveIndexFiles(new File(workDir, "issues"), indexDirectory);
        }

        private void cleanDirectoryWithRetries(String path) {
            File directory = new File(path);
            if (!directory.exists()) {
                return;
            }
            for (int attempts = 1; attempts <= 3; ++attempts) {
                try {
                    FileUtils.cleanDirectory((File)directory);
                    return;
                }
                catch (IOException e) {
                    if (attempts < 3) {
                        LOG.warn((Object)String.format("Failed to clean the indexes in directory '%s', attempt [%d] out of [%d]. Retrying the operation.", path, attempts, 3));
                        try {
                            Thread.sleep((long)attempts * 100L);
                        }
                        catch (InterruptedException interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    } else {
                        LOG.error((Object)String.format("Failed to clean the indexes in directory '%s', attempt [%d] out of [%d]. Giving up. Old indexes should get automatically deleted during the next index recovery.", path, attempts, 3));
                    }
                    DefaultIndexRecoveryManager.this.threadDumper.run();
                    continue;
                }
            }
        }

        private void moveIndexFiles(File workIndexDir, File indexDir) {
            File actualIndexDir = new File(indexDir, workIndexDir.getName());
            if (!workIndexDir.exists() || !workIndexDir.isDirectory()) {
                LOG.warn((Object)String.format("'%s' does not exist or is not a directory", workIndexDir));
                return;
            }
            Collection indexFiles = FileUtils.listFiles((File)workIndexDir, null, (boolean)true);
            for (File indexFile : indexFiles) {
                File dest = new File(actualIndexDir, workIndexDir.toURI().relativize(indexFile.toURI()).getPath());
                try {
                    FileUtils.moveFile((File)indexFile, (File)dest);
                }
                catch (IOException e) {
                    LOG.error((Object)String.format("Unable to move the index file from '%s' to '%s'", indexFile, dest), (Throwable)e);
                }
            }
        }
    }
}

