/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.NodeIndexCounterStore;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReindexMetadata;
import com.atlassian.jira.index.ha.ReplicatedIndexManager;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.TemporaryFilesProvider;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultReplicatedIndexManager
implements ReplicatedIndexManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultReplicatedIndexManager.class);
    private final OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore;
    private final NodeIndexCounterStore nodeIndexCounterStore;
    private final ClusterInfo clusterInfo;
    private final TaskManager taskManager;

    public DefaultReplicatedIndexManager(OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore, NodeIndexCounterStore nodeIndexCounterStore, ClusterInfo clusterInfo, TaskManager taskManager) {
        this.ofBizReplicatedIndexOperationStore = ofBizReplicatedIndexOperationStore;
        this.nodeIndexCounterStore = nodeIndexCounterStore;
        this.clusterInfo = clusterInfo;
        this.taskManager = taskManager;
    }

    @Override
    public void reindexIssues(@Nonnull IssuesIterable issuesIterable, @Nonnull IssueIndexingParams issueIndexingParams) {
        try {
            HashSet issueIds = Sets.newHashSet();
            issuesIterable.foreach(issue -> issueIds.add(issue.getId()));
            ReplicatedIndexOperation.Operation operation = ReplicatedIndexOperation.Operation.UPDATE;
            if (issueIndexingParams.getAffectedIndexCount() > 1) {
                operation = ReplicatedIndexOperation.Operation.UPDATE_WITH_RELATED;
            }
            this.updateReplicatedIndex(issueIds, AffectedIndex.ISSUE, SharedEntityType.NONE, operation);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage("reindexed issues"), (Throwable)e);
        }
    }

    @Override
    public void reindexComments(Collection<Comment> comments) {
        this.reindexEntity(comments, AffectedIndex.COMMENT);
    }

    @Override
    public void reindexWorklogs(Collection<Worklog> worklogs) {
        this.reindexEntity(worklogs, AffectedIndex.WORKLOG);
    }

    @Override
    public <T extends WithId> void reindexEntity(Collection<T> entities, AffectedIndex index) {
        try {
            HashSet entityIds = Sets.newHashSet();
            for (WithId entity : entities) {
                entityIds.add(entity.getId());
            }
            this.updateReplicatedIndex(entityIds, index, SharedEntityType.NONE, ReplicatedIndexOperation.Operation.UPDATE);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage("reindexed " + index));
        }
    }

    @Override
    public void deIndexIssues(Set<Issue> issuesToDelete) {
        try {
            HashSet issueIds = Sets.newHashSet();
            if (issuesToDelete != null) {
                for (Issue issue : issuesToDelete) {
                    issueIds.add(issue.getId());
                }
            }
            this.updateReplicatedIndex(issueIds, AffectedIndex.ISSUE, SharedEntityType.NONE, ReplicatedIndexOperation.Operation.DELETE);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage("deindexed issues"), (Throwable)e);
        }
    }

    @Override
    public void reindexProject(Project project) {
        this.updateReplicatedIndex((Set<Long>)ImmutableSet.of((Object)project.getId()), AffectedIndex.ISSUE, SharedEntityType.NONE, ReplicatedIndexOperation.Operation.PROJECT_REINDEX);
    }

    @Override
    public void deIndexProject(Project project) {
        this.updateReplicatedIndex((Set<Long>)ImmutableSet.of((Object)project.getId()), AffectedIndex.ISSUE, SharedEntityType.NONE, ReplicatedIndexOperation.Operation.PROJECT_DEINDEX);
    }

    @Override
    public void indexSharedEntity(SharedEntity entity) {
        try {
            this.updateReplicatedIndex((Set<Long>)ImmutableSet.of((Object)entity.getId()), AffectedIndex.SHAREDENTITY, SharedEntityType.fromTypeDescriptor((SharedEntity.TypeDescriptor)entity.getEntityType()), ReplicatedIndexOperation.Operation.UPDATE);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage("reindexed shared entity"), (Throwable)e);
        }
    }

    @Override
    public void deIndexSharedEntity(SharedEntity entity) {
        try {
            this.updateReplicatedIndex((Set<Long>)ImmutableSet.of((Object)entity.getId()), AffectedIndex.SHAREDENTITY, SharedEntityType.fromTypeDescriptor((SharedEntity.TypeDescriptor)entity.getEntityType()), ReplicatedIndexOperation.Operation.DELETE);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage("deindexed shared entity"), (Throwable)e);
        }
    }

    @EventListener
    public void onReindexAllStarted(ReindexAllStartedEvent reindexAllStartedEvent) {
        if (reindexAllStartedEvent.shouldUpdateReplicatedIndex()) {
            ReplicatedIndexOperation.Operation reindex = reindexAllStartedEvent.isUsingBackgroundIndexing() ? ReplicatedIndexOperation.Operation.BACKGROUND_REINDEX_START : ReplicatedIndexOperation.Operation.FULL_REINDEX_START;
            this.ofBizReplicatedIndexOperationStore.createIndexOperation(new Timestamp(System.currentTimeMillis()), AffectedIndex.ALL, SharedEntityType.NONE, reindex, Collections.emptySet(), "");
        }
    }

    @EventListener
    public void onReindexAllCompleted(ReindexAllCompletedEvent reindexAllCompletedEvent) {
        if (reindexAllCompletedEvent.shouldUpdateReplicatedIndex()) {
            ReplicatedIndexOperation.Operation reindex = reindexAllCompletedEvent.isUsingBackgroundIndexing() ? ReplicatedIndexOperation.Operation.BACKGROUND_REINDEX_END : ReplicatedIndexOperation.Operation.FULL_REINDEX_END;
            ClusterNodeProperties clusterNodeProperties = (ClusterNodeProperties)ComponentAccessor.getComponent(ClusterNodeProperties.class);
            IndexCopyService indexCopyService = (IndexCopyService)ComponentAccessor.getComponent(IndexCopyService.class);
            String backupFilename = indexCopyService.backupIndex(clusterNodeProperties.getNodeId(), new ReindexMetadataFilesProvider(reindexAllCompletedEvent));
            this.ofBizReplicatedIndexOperationStore.createIndexOperation(new Timestamp(System.currentTimeMillis()), AffectedIndex.ALL, SharedEntityType.NONE, reindex, Collections.emptySet(), backupFilename);
        } else {
            TaskDescriptor taskDescriptor = this.taskManager.getLiveTask(new IndexTaskContext());
            if (taskDescriptor != null && taskDescriptor.isFinished()) {
                this.taskManager.removeTask(taskDescriptor.getTaskId());
            }
        }
    }

    private void updateReplicatedIndex(Set<Long> ids, AffectedIndex affectedIndex, SharedEntityType entityType, ReplicatedIndexOperation.Operation operation) {
        ReplicatedIndexOperation replicatedIndexOperation = this.ofBizReplicatedIndexOperationStore.createIndexOperation(new Timestamp(System.currentTimeMillis()), affectedIndex, entityType, operation, ids, "");
        if (replicatedIndexOperation != null && this.clusterInfo.isClustered()) {
            log.trace("Adding for current node: {} replicatedIndexOperation: {}", (Object)this.clusterInfo.getNodeId(), (Object)replicatedIndexOperation.getId());
            this.nodeIndexCounterStore.storeHighestIdForNode(this.clusterInfo.getNodeId(), replicatedIndexOperation.getId());
        }
    }

    private String buildErrorMessage(String indexOperationInError) {
        return String.format("Caught an exception trying to replicate %s.  The replicated index may or may not be correct", indexOperationInError);
    }

    private class ReindexMetadataFilesProvider
    implements TemporaryFilesProvider {
        private final ReindexAllCompletedEvent reindexAllCompletedEvent;

        public ReindexMetadataFilesProvider(ReindexAllCompletedEvent reindexAllCompletedEvent) {
            this.reindexAllCompletedEvent = reindexAllCompletedEvent;
        }

        @Override
        public Collection<File> writeContribution(File indexDir) throws IOException {
            ReindexMetadata metadata = new ReindexMetadata();
            if (this.reindexAllCompletedEvent.getIndexStartTime() >= 0L) {
                metadata.setIndexStartTime(this.reindexAllCompletedEvent.getIndexStartTime());
            }
            return Collections.singleton(metadata.storeTo(indexDir));
        }
    }
}

