/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.entity.AbstractEntityFactory;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.ofbiz.FieldMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class ReplicatedIndexOperationFactory
extends AbstractEntityFactory<ReplicatedIndexOperation> {
    @Override
    public Map<String, Object> fieldMapFrom(@Nonnull ReplicatedIndexOperation value) {
        return new FieldMap("id", (Object)value.getId()).add("nodeId", (Object)value.getNodeId()).add("indexTime", (Object)value.getIndexTime()).add("affectedIndex", (Object)value.getAffectedIndex().toString()).add("entityType", (Object)value.getEntityType().toString()).add("operation", (Object)value.getOperation().toString()).add("affectedIds", (Object)this.serialize(value.getAffectedIds())).add("filename", (Object)value.getBackupFilename());
    }

    @Override
    public String getEntityName() {
        return "ReplicatedIndexOperation";
    }

    @Override
    public ReplicatedIndexOperation build(@Nonnull GenericValue gv) {
        return new ReplicatedIndexOperation(gv.getLong("id"), gv.getString("nodeId"), gv.getTimestamp("indexTime"), AffectedIndex.valueOf((String)gv.getString("affectedIndex")), SharedEntityType.valueOf((String)gv.getString("entityType")), ReplicatedIndexOperation.Operation.valueOf(gv.getString("operation")), this.deserialize(gv.getString("affectedIds")), gv.getString("filename"));
    }

    private Set<Long> deserialize(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return Sets.newHashSet();
        }
        String[] affectedIdStrings = ids.split(",");
        HashSet affectedIds = Sets.newHashSet();
        for (String id : affectedIdStrings) {
            affectedIds.add(Long.parseLong(id));
        }
        return affectedIds;
    }

    private String serialize(Set<Long> ids) {
        return StringUtils.join(ids, (String)",");
    }
}

