/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.instrumentation.ExternalCounter;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.instrumentation.Instrumentation;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;

class ClassLoadingExternalGauges {
    ClassLoadingExternalGauges() {
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.class.loaded.current", (ExternalValue)new ClassLoaderMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getLoadedClassCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalCounter("jmx.class.unloaded.total", (ExternalValue)new ClassLoaderMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getUnloadedClassCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalCounter("jmx.class.loaded.total", (ExternalValue)new ClassLoaderMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getTotalLoadedClassCount();
            }
        }));
    }

    private static abstract class ClassLoaderMXExternalValue
    implements ExternalValue {
        private ClassLoaderMXExternalValue() {
        }

        ClassLoadingMXBean getMxBean() {
            return ManagementFactory.getClassLoadingMXBean();
        }
    }
}

