/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.archiving.query.ArchiveQuery;
import com.atlassian.jira.issue.archiving.query.ArchivedIssue;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
public interface ArchivedIssueSearchService {
    public List<Issue> getArchivedIssuesMatchingTypesInProjects(List<Long> var1, List<String> var2);

    public ValidationResult validateSearch(ArchiveSearchRequest var1);

    public ValidationResult validateSearchOverrideSecurity(ArchiveSearchRequest var1);

    public Stream<ArchivedIssue> search(ValidationResult var1);

    public int count(ValidationResult var1);

    public static class ArchiveSearchRequest {
        List<String> projectKeysOrIds = ImmutableList.of();
        List<String> reporters = ImmutableList.of();
        List<String> issueTypes = ImmutableList.of();
        List<String> archivedBy = ImmutableList.of();
        int maxResults = 0;
        Long archivedBefore;
        Long archivedAfter;

        public ArchiveSearchRequest setMaxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public ArchiveSearchRequest setProjectKeyOrId(List<String> projectKeysOrIds) {
            this.projectKeysOrIds = this.prepareList(projectKeysOrIds);
            return this;
        }

        public ArchiveSearchRequest setReporter(List<String> reporters) {
            this.reporters = this.prepareList(reporters);
            return this;
        }

        public ArchiveSearchRequest setIssueType(List<String> issueTypes) {
            this.issueTypes = this.prepareList(issueTypes);
            return this;
        }

        public ArchiveSearchRequest setArchivedBy(List<String> archivedBy) {
            this.archivedBy = this.prepareList(archivedBy);
            return this;
        }

        public ArchiveSearchRequest setArchivedBefore(Long archivedBefore) {
            this.archivedBefore = archivedBefore;
            return this;
        }

        public ArchiveSearchRequest setArchivedAfter(Long archivedAfter) {
            this.archivedAfter = archivedAfter;
            return this;
        }

        private List<String> prepareList(List<String> l1) {
            if (l1 == null) {
                return ImmutableList.of();
            }
            return l1.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        }
    }

    public static final class ValidationResult
    extends ServiceResultImpl {
        private final ArchiveQuery query;

        protected ValidationResult(ArchiveQuery query) {
            super(ErrorCollections.empty());
            this.query = query;
        }

        protected ValidationResult(@Nonnull ErrorCollection errorCollection) {
            super(errorCollection);
            this.query = null;
        }

        public boolean isValid() {
            return super.isValid() && this.query != null;
        }

        public ArchiveQuery getQuery() {
            return this.query;
        }
    }
}

