/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentImpl;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.model.querydsl.ActionDTO;
import com.atlassian.jira.model.querydsl.QAction;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraDateUtils;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.StatementOptions;
import java.util.Date;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StreamingCommentsRetriever {
    private static final int COMMENTS_FETCH_SIZE = 10000;
    private final QueryDslAccessor queryDslAccessor;
    private final ProjectRoleManager projectRoleManager;
    private final UserManager userManager;
    private final CommentPermissionManager commentPermissionManager;
    private final DatabaseConfig databaseConfiguration;

    public StreamingCommentsRetriever(QueryDslAccessor queryDslAccessor, ProjectRoleManager projectRoleManager, UserManager userManager, CommentPermissionManager commentPermissionManager, DatabaseConfigurationManager databaseConfigurationManager) {
        this.queryDslAccessor = queryDslAccessor;
        this.projectRoleManager = projectRoleManager;
        this.userManager = userManager;
        this.commentPermissionManager = commentPermissionManager;
        this.databaseConfiguration = databaseConfigurationManager.getDatabaseConfiguration();
    }

    public Stream<Comment> stream(@Nullable ApplicationUser user, final @Nonnull Issue issue) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<ActionDTO>(Long.MAX_VALUE, 1024){
            ActionDTO lastComment;
            Spliterator<ActionDTO> batch;
            boolean lastBatch;
            {
                super(x0, x1);
                this.lastComment = null;
                this.batch = Spliterators.emptySpliterator();
                this.lastBatch = false;
            }

            @Override
            public boolean tryAdvance(Consumer<? super ActionDTO> action) {
                boolean advanced = this.batch.tryAdvance(action);
                if (!advanced && !this.lastBatch) {
                    List comments = StreamingCommentsRetriever.this.getCommentsForBatch(issue, this.lastComment);
                    if (!comments.isEmpty()) {
                        this.lastComment = (ActionDTO)comments.get(comments.size() - 1);
                    }
                    if (comments.size() < 10000) {
                        this.lastBatch = true;
                    }
                    this.batch = comments.spliterator();
                    return this.batch.tryAdvance(action);
                }
                return advanced;
            }
        }, false).map(dto -> this.convertToComment((ActionDTO)dto, issue)).filter(c -> this.commentPermissionManager.hasBrowsePermission(user, c));
    }

    @Nonnull
    private List<ActionDTO> getCommentsForBatch(Issue issue, ActionDTO lastComment) {
        return this.queryDslAccessor.executeQuery(con -> {
            BooleanBuilder where = new BooleanBuilder();
            where.and((Predicate)QAction.ACTION.issue.eq((Object)issue.getId()));
            where.and((Predicate)QAction.ACTION.type.eq((Object)"comment"));
            if (lastComment != null) {
                where.and((Predicate)QAction.ACTION.created.gt((Comparable)lastComment.getCreated()).or((Predicate)QAction.ACTION.created.eq((Object)lastComment.getCreated()).and((Predicate)QAction.ACTION.id.gt((Number)lastComment.getId()))));
            }
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.newSqlQuery(con).select((Expression)QAction.ACTION).from((Expression)QAction.ACTION)).where((Predicate)where)).orderBy(new OrderSpecifier[]{QAction.ACTION.created.asc(), QAction.ACTION.id.asc()})).limit(10000L)).fetch();
        });
    }

    private SQLQuery<?> newSqlQuery(DbConnection con) {
        SQLQuery<?> query = con.newSqlQuery();
        int fetchSize = this.databaseConfiguration.isMySql() ? Integer.MIN_VALUE : 10000;
        query.setStatementOptions(StatementOptions.builder().setFetchSize(Integer.valueOf(fetchSize)).build());
        return query;
    }

    private Comment convertToComment(ActionDTO actionDTO, Issue issue) {
        CommentImpl comment = new CommentImpl(this.projectRoleManager, this.userManager.getUserByKeyEvenWhenUnknown(actionDTO.getAuthor()), this.userManager.getUserByKeyEvenWhenUnknown(actionDTO.getUpdateauthor()), actionDTO.getBody(), actionDTO.getLevel(), actionDTO.getRolelevel(), JiraDateUtils.copyDateNullsafe((Date)actionDTO.getCreated()), JiraDateUtils.copyDateNullsafe((Date)actionDTO.getUpdated()), issue);
        comment.setId(actionDTO.getId());
        return comment;
    }
}

