/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;

public class NumberCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<Double> {
    private final DoubleConverter doubleConverter;

    public NumberCustomFieldOperationsHandler(CustomField field, DoubleConverter doubleConverter, I18nHelper i18nHelper) {
        super(field, i18nHelper);
        this.doubleConverter = doubleConverter;
    }

    protected Double getInitialValue(Issue issue, ErrorCollection errors) {
        return (Double)this.field.getValue(issue);
    }

    protected Double getInitialCreateValue(IssueContext issueCtx) {
        return null;
    }

    protected void finaliseOperation(Double finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.addCustomFieldValue(this.field.getId(), new String[]{finalValue != null ? this.doubleConverter.getString(finalValue) : null});
    }

    protected Double handleSetOperation(IssueContext issueCtx, Issue issue, Double currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (operationValue.isNull()) {
            return null;
        }
        Object data = operationValue.getData();
        if (!(data instanceof Number)) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.operation.must.be.number"), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        return ((Number)data).doubleValue();
    }
}

