/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.option;

import com.atlassian.jira.issue.comparator.BeanComparatorIgnoreCase;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.CollectionReorderer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OptionsImpl
extends ArrayList<Option>
implements Options {
    private static final long serialVersionUID = 1946632069203605222L;
    private final Map<Long, Option> optionsLookup;
    private final FieldConfig relatedField;
    private final OptionsManager optionsManager;

    public OptionsImpl(List<Option> options, FieldConfig relatedField, OptionsManager optionsManager) {
        this.relatedField = relatedField;
        this.optionsManager = optionsManager;
        this.optionsLookup = new HashMap<Long, Option>();
        this.populateFromOptions(options);
    }

    private void populateFromOptions(List<Option> options) {
        if (options != null && !options.isEmpty()) {
            ArrayList rootOptions = Lists.newArrayList();
            for (Option option : options) {
                Option parentOption = option.getParentOption();
                if (parentOption == null) {
                    rootOptions.add(option);
                }
                this.optionsLookup.put(option.getOptionId(), option);
            }
            this.addAll(rootOptions);
        }
    }

    public List<Option> getRootOptions() {
        return this;
    }

    private Collection<Option> getPeerOptions(Option option) {
        Option parentOption = option.getParentOption();
        if (parentOption != null) {
            return parentOption.getChildOptions();
        }
        return this.getRootOptions();
    }

    public Option getOptionForValue(String value, Long parentOptionId) {
        List optionsForParent = parentOptionId != null ? this.getOptionById(parentOptionId).getChildOptions() : this.getRootOptions();
        if (optionsForParent != null) {
            for (Option option : optionsForParent) {
                if (option == null || option.getValue() == null || !option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
        }
        return null;
    }

    public void setValue(Option option, String value) {
        this.optionsManager.setValue(option, value);
    }

    public Option addOption(Option parent, String value) {
        Long parentOptionId;
        List<Option> parentColl;
        if (parent != null) {
            parentColl = parent.getChildOptions();
            parentOptionId = parent.getOptionId();
        } else {
            parentColl = this.getRootOptions();
            parentOptionId = null;
        }
        long lastPosition = parentColl != null ? (long)parentColl.size() : 0L;
        return this.optionsManager.createOption(this.getRelatedFieldConfig(), parentOptionId, Long.valueOf(lastPosition), value);
    }

    public void removeOption(Option option) {
        this.optionsManager.deleteOptionAndChildren(option);
        Collection<Option> peers = this.getPeerOptions(option);
        int i = 0;
        Iterator<Option> iterator = peers.iterator();
        while (iterator.hasNext()) {
            Option currentOption = iterator.next();
            if (currentOption.equals(option)) {
                iterator.remove();
                continue;
            }
            currentOption.setSequence(Long.valueOf(i));
            ++i;
        }
        this.optionsManager.updateOptions(peers);
    }

    public void sortOptionsByValue(Option parentOption) {
        ArrayList<Option> options = new ArrayList<Option>(parentOption != null ? parentOption.getChildOptions() : this.getRootOptions());
        Collections.sort(options, new BeanComparatorIgnoreCase("value"));
        this.renumberOptions(options);
        this.optionsManager.updateOptions(options);
    }

    public void moveOptionToPosition(Map<Integer, Option> positionsToOptions) {
        if (positionsToOptions.isEmpty()) {
            return;
        }
        Option option = positionsToOptions.values().iterator().next();
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        CollectionReorderer.moveToPosition(peerOptions, positionsToOptions);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    public void moveToStartSequence(Option option) {
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        CollectionReorderer.moveToStart(peerOptions, option);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    public void incrementSequence(Option option) {
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        CollectionReorderer.decreasePosition(peerOptions, option);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    public void decrementSequence(Option option) {
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        CollectionReorderer.increasePosition(peerOptions, option);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    public void moveToLastSequence(Option option) {
        ArrayList<Option> peerOptions = new ArrayList<Option>(this.getPeerOptions(option));
        CollectionReorderer.moveToEnd(peerOptions, option);
        this.renumberOptions(peerOptions);
        this.optionsManager.updateOptions(peerOptions);
    }

    public void disableOption(Option option) {
        this.optionsManager.disableOption(option);
    }

    public void enableOption(Option option) {
        this.optionsManager.enableOption(option);
    }

    public Option getOptionById(Long optionId) {
        return this.optionsLookup.get(optionId);
    }

    public FieldConfig getRelatedFieldConfig() {
        return this.relatedField;
    }

    private void renumberOptions(List<Option> options) {
        if (options != null) {
            int pos = 0;
            for (Option option : options) {
                option.setSequence(Long.valueOf(pos));
                ++pos;
            }
        }
    }
}

