/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.comment.property.DefaultCommentPropertyService;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.CommentField;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.UnscreenableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.fields.renderer.comment.CommentFieldRenderer;
import com.atlassian.jira.issue.fields.rest.CommentRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.StreamingCommentsJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.operation.WorkflowIssueOperation;
import com.atlassian.jira.issue.search.handlers.CommentSearchHandlerFactory;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.views.util.csv.CsvDateFormatter;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.plugin.webfragment.model.CommentHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.issue.bulkedit.BulkWorkflowTransition;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;

public class CommentSystemField
extends AbstractOrderableField<Map<String, Object>>
implements RenderableField,
UnscreenableField,
CommentField,
RestAwareField,
RestFieldOperations,
ExportableSystemField {
    public static final String CREATE_COMMENT = "comment.create.param";
    public static final String EDIT_COMMENT = "comment.edit.param";
    public static final String REMOVE_COMMENT = "comment.remove.param";
    private static final Logger log = LoggerFactory.getLogger(CommentSystemField.class);
    private static final String COMMENT_NAME_KEY = "issue.field.comment";
    public static final String PARAM_GROUP_LEVEL = "groupLevel";
    public static final String PARAM_COMMENT_LEVEL = "commentLevel";
    public static final String PARAM_COMMENT_OBJECT = "commentObject";
    public static final String PARAM_COMMENT_PROPERTY = "commentProperty";
    public static final String PARAM_ROLE_LEVEL = "roleLevel";
    public static final String PARAM_COMMENT_ID = "comment:id";
    public static final String PARAM_LEVEL_PRESENT = "levelPresent";
    private final RendererManager rendererManager;
    private final JiraAuthenticationContext authenticationContext;
    private final CommentService commentService;
    private final ProjectRoleManager projectRoleManager;
    private final GroupManager groupManager;
    private final CommentManager commentManager;
    private final MentionService mentionService;
    private final CommentFieldRenderer commentFieldRenderer;
    private final DefaultCommentPropertyService commentPropertyService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final CsvDateFormatter csvDateFormatter;

    public CommentSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, RendererManager rendererManager, PermissionManager permissionManager, CommentService commentService, ProjectRoleManager projectRoleManager, CommentSearchHandlerFactory searchHandlerFactory, GroupManager groupManager, CommentManager commentManager, MentionService mentionService, CommentFieldRenderer commentFieldRenderer, DefaultCommentPropertyService commentPropertyService, I18nHelper.BeanFactory i18nFactory, CsvDateFormatter csvDateFormatter) {
        super("comment", COMMENT_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.rendererManager = rendererManager;
        this.authenticationContext = authenticationContext;
        this.commentService = commentService;
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
        this.commentManager = commentManager;
        this.mentionService = mentionService;
        this.commentFieldRenderer = commentFieldRenderer;
        this.commentPropertyService = commentPropertyService;
        this.i18nFactory = i18nFactory;
        this.csvDateFormatter = csvDateFormatter;
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        String[] commentId;
        HashMap<String, Object> commentParams = new HashMap<String, Object>();
        String[] value = params.get(this.getId());
        if (value != null && value.length > 0) {
            commentParams.put(this.getId(), value[0]);
        }
        CommentVisibility commentVisibility = new CommentVisibility(params, PARAM_COMMENT_LEVEL);
        commentParams.put(PARAM_LEVEL_PRESENT, commentVisibility.isPresent());
        commentParams.put(PARAM_GROUP_LEVEL, commentVisibility.getGroupLevel());
        commentParams.put(PARAM_ROLE_LEVEL, commentVisibility.getRoleLevel());
        if (params.containsKey(CREATE_COMMENT)) {
            commentParams.put(CREATE_COMMENT, params.get(CREATE_COMMENT));
        } else if (params.containsKey(EDIT_COMMENT)) {
            commentParams.put(EDIT_COMMENT, params.get(EDIT_COMMENT));
        } else if (params.containsKey(REMOVE_COMMENT)) {
            commentParams.put(REMOVE_COMMENT, params.get(REMOVE_COMMENT));
        }
        if (params.containsKey(PARAM_COMMENT_ID) && (commentId = params.get(PARAM_COMMENT_ID)) != null && commentId.length > 0) {
            commentParams.put(PARAM_COMMENT_ID, commentId[0]);
        }
        if (params.containsKey(PARAM_COMMENT_OBJECT)) {
            commentParams.put(PARAM_COMMENT_OBJECT, params.get(PARAM_COMMENT_OBJECT));
        }
        if (params.containsKey(PARAM_COMMENT_PROPERTY)) {
            commentParams.put(PARAM_COMMENT_PROPERTY, params.get(PARAM_COMMENT_PROPERTY));
        }
        return commentParams;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map commentParams;
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        this.populateVelocityParams(fieldLayoutItem, null, velocityParams);
        if (operationContext != null && operationContext.getFieldValuesHolder() != null && operationContext.getFieldValuesHolder().containsKey(this.getId()) && (commentParams = (Map)operationContext.getFieldValuesHolder().get(this.getId())) != null) {
            velocityParams.put(this.getId(), commentParams.get(this.getId()));
            this.populateParamsWithSelectedValue(commentParams, velocityParams);
        }
        return this.commentFieldRenderer.getIssuePageEditHtml(velocityParams, CommentHelper.builder().issue(issue).build());
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map commentParams;
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        this.populateVelocityParams(fieldLayoutItem, operationContext != null ? operationContext.getFieldValuesHolder() : null, velocityParams);
        CommentHelper.CommentHelperBuilder helperBuilder = CommentHelper.builder().issue(issue);
        if (operationContext != null && operationContext.getFieldValuesHolder() != null && operationContext.getFieldValuesHolder().containsKey(this.getId()) && (commentParams = (Map)operationContext.getFieldValuesHolder().get(this.getId())) != null) {
            velocityParams.put(this.getId(), commentParams.get(this.getId()));
            this.populateParamsWithSelectedValue(commentParams, velocityParams);
            helperBuilder.comment((Comment)commentParams.get(PARAM_COMMENT_OBJECT));
        }
        return this.commentFieldRenderer.getFieldEditHtml(velocityParams, helperBuilder.build());
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Comment system field does not know how to obtain a comment value given an Issue.");
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map<String, Object> value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        IssueRenderContext context = issue != null ? issue.getIssueRenderContext() : new IssueRenderContext(null);
        String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
        velocityParams.put("value", this.rendererManager.getRenderedContent(rendererType, (String)value.get(this.getId()), context));
        if (value.containsKey(PARAM_GROUP_LEVEL)) {
            velocityParams.put(PARAM_GROUP_LEVEL, value.get(PARAM_GROUP_LEVEL));
        }
        if (value.containsKey(PARAM_ROLE_LEVEL)) {
            ProjectRole projectRole;
            String roleId = (String)value.get(PARAM_ROLE_LEVEL);
            if (roleId != null && (projectRole = this.projectRoleManager.getProjectRole(new Long(roleId))) != null) {
                velocityParams.put("selectedRoleName", projectRole.getName());
            }
            velocityParams.put(PARAM_ROLE_LEVEL, roleId);
        }
        if (value.containsKey(PARAM_COMMENT_PROPERTY)) {
            velocityParams.put(PARAM_COMMENT_PROPERTY, value.get(PARAM_COMMENT_PROPERTY));
        }
        return this.commentFieldRenderer.getFieldViewHtml(velocityParams, CommentHelper.builder().issue(issue).build());
    }

    public boolean isShown(Issue issue) {
        return this.hasPermission(issue, 15);
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        HashMap<String, Object> commentParams = new HashMap<String, Object>();
        commentParams.put(this.getId(), "");
        commentParams.put(PARAM_GROUP_LEVEL, null);
        commentParams.put(PARAM_LEVEL_PRESENT, true);
        fieldValuesHolder.put(this.getId(), commentParams);
    }

    public void populateAdditionalInputs(Map fieldValuesHolder, Map<String, Object> additionalInputs) {
        String comment;
        Map commentParams = (Map)fieldValuesHolder.get(this.getId());
        if (commentParams != null && StringUtils.isNotBlank((CharSequence)(comment = (String)commentParams.get(this.getId())))) {
            additionalInputs.put("comment", commentParams.get(this.getId()));
            additionalInputs.put(PARAM_COMMENT_LEVEL, commentParams.get(PARAM_GROUP_LEVEL));
            additionalInputs.put(PARAM_ROLE_LEVEL, commentParams.get(PARAM_ROLE_LEVEL));
            additionalInputs.put(PARAM_ROLE_LEVEL, commentParams.get(PARAM_ROLE_LEVEL));
            additionalInputs.put(PARAM_COMMENT_PROPERTY, commentParams.get(PARAM_COMMENT_PROPERTY));
        }
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        this.populateDefaults(fieldValuesHolder, issue);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        Map commentParams = (Map)fieldValuesHolder.get(this.getId());
        String body = (String)commentParams.get(this.getId());
        String groupLevel = (String)commentParams.get(PARAM_GROUP_LEVEL);
        String roleLevel = (String)commentParams.get(PARAM_ROLE_LEVEL);
        boolean levelPresent = (Boolean)commentParams.get(PARAM_LEVEL_PRESENT);
        Visibility visibility = Visibilities.fromGroupAndStrRoleId((boolean)levelPresent, (String)groupLevel, (String)roleLevel);
        ApplicationUser user = this.authenticationContext.getUser();
        if (commentParams.containsKey(EDIT_COMMENT)) {
            this.validateEditComment(errorCollectionToAddTo, issue, commentParams, body, visibility, user);
        } else if (commentParams.containsKey(REMOVE_COMMENT)) {
            this.validateRemoveComment(errorCollectionToAddTo, commentParams, user);
        } else {
            this.validateCreateComment(operationContext, errorCollectionToAddTo, issue, commentParams, body, visibility, user);
        }
    }

    private void validateRemoveComment(ErrorCollection errorCollectionToAddTo, Map<String, Object> commentParams, ApplicationUser user) {
        Object commentIdObj = commentParams.get(PARAM_COMMENT_ID);
        if (commentIdObj != null) {
            try {
                Long commentId = Long.valueOf((String)commentIdObj);
                this.commentService.hasPermissionToDelete((JiraServiceContext)new JiraServiceContextImpl(user, errorCollectionToAddTo), commentId);
            }
            catch (NumberFormatException ex) {
                errorCollectionToAddTo.addError("comment", "invalid comment id specified.");
            }
        } else {
            errorCollectionToAddTo.addError("comment", "no comment id specified.");
        }
    }

    private void validateCreateComment(OperationContext operationContext, ErrorCollection errorCollection, Issue issue, Map<String, Object> commentParams, String body, Visibility visibility, ApplicationUser user) {
        if (StringUtils.isNotBlank((CharSequence)body)) {
            if (operationContext.getIssueOperation() instanceof WorkflowIssueOperation) {
                this.commentService.hasPermissionToCreate(user, issue, errorCollection, ((WorkflowIssueOperation)operationContext.getIssueOperation()).getActionDescriptor());
            } else {
                this.commentService.hasPermissionToCreate(user, issue, errorCollection);
            }
        }
        boolean allowEmptyComments = true;
        if (commentParams.get(CREATE_COMMENT) != null) {
            allowEmptyComments = false;
        }
        this.commentService.isValidCommentBody(body, errorCollection, allowEmptyComments);
        this.commentService.isValidCommentVisibility(user, issue, visibility, errorCollection);
        this.validateCommentProperties(commentParams, errorCollection);
    }

    private void validateEditComment(ErrorCollection errorCollection, Issue issue, Map<String, Object> commentParams, String body, Visibility visibility, ApplicationUser user) {
        if (commentParams.get(PARAM_COMMENT_ID) != null) {
            try {
                this.commentService.isValidCommentBody(body, errorCollection);
                Long commentIdAsLong = Long.valueOf((String)commentParams.get(PARAM_COMMENT_ID));
                this.commentService.hasPermissionToEdit((JiraServiceContext)new JiraServiceContextImpl(user, errorCollection), commentIdAsLong);
                this.commentService.isValidCommentVisibility(user, issue, visibility, errorCollection);
                this.validateCommentProperties(commentParams, errorCollection);
            }
            catch (NumberFormatException ex) {
                errorCollection.addError("comment", "invalid comment id specified.");
            }
        } else {
            errorCollection.addError("comment", "no comment id specified.");
        }
    }

    public Map<String, Object> getDefaultValue(Issue issue) {
        return null;
    }

    public void createValue(Issue issue, Map<String, Object> value) {
        throw new UnsupportedOperationException("CreateValue on the comment system field is unsupported.");
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Map commentParams = (Map)modifiedValue.getNewValue();
        String body = (String)commentParams.get(this.getId());
        String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
        body = (String)this.rendererManager.getRendererForType(rendererType).transformFromEdit((Object)body);
        if (commentParams.containsKey(EDIT_COMMENT)) {
            this.editComment(issueChangeHolder, commentParams, body);
        } else if (commentParams.containsKey(REMOVE_COMMENT)) {
            this.removeComment(issueChangeHolder, commentParams);
        } else if (StringUtils.isNotBlank((CharSequence)body)) {
            this.createComment(issue, issueChangeHolder, commentParams, body);
        }
    }

    private void removeComment(IssueChangeHolder issueChangeHolder, Map commentParams) {
        ApplicationUser user = this.authenticationContext.getUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        long commentId = Long.valueOf((String)commentParams.get(PARAM_COMMENT_ID));
        Comment comment = this.commentService.getCommentById(user, Long.valueOf(commentId), (ErrorCollection)errorCollection);
        this.commentService.delete((JiraServiceContext)new JiraServiceContextImpl(user, (ErrorCollection)errorCollection), comment, true);
        if (errorCollection.hasAnyErrors()) {
            log.error("Error updating comment id '" + commentId + "' Error(s): '" + errorCollection.toString() + "'");
        } else {
            issueChangeHolder.setComment(comment);
        }
    }

    private void editComment(IssueChangeHolder issueChangeHolder, Map<String, Object> commentParams, String body) {
        ApplicationUser user = this.authenticationContext.getUser();
        long commentId = Long.valueOf((String)commentParams.get(PARAM_COMMENT_ID));
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        MutableComment mutableComment = this.commentService.getMutableComment(user, Long.valueOf(commentId), (ErrorCollection)errorCollection);
        CommentService.CommentParameters.CommentParametersBuilder builder = CommentService.CommentParameters.builder((Comment)mutableComment);
        if (StringUtils.isNotBlank((CharSequence)body)) {
            builder.body(body);
        }
        String groupLevel = (String)commentParams.get(PARAM_GROUP_LEVEL);
        String roleLevelIdStr = (String)commentParams.get(PARAM_ROLE_LEVEL);
        builder.visibility(Visibilities.fromGroupAndStrRoleId((String)groupLevel, (String)roleLevelIdStr));
        builder.commentProperties(this.getCommentPropertiesQuietly(commentParams));
        CommentService.CommentUpdateValidationResult validationResult = this.commentService.validateCommentUpdate(user, Long.valueOf(commentId), builder.build());
        if (validationResult.isValid()) {
            this.commentService.update(user, validationResult, true);
            issueChangeHolder.setComment((Comment)mutableComment);
        } else {
            log.error("Error updating comment id '" + commentId + "' Error(s): '" + errorCollection.toString() + "'");
        }
    }

    private void createComment(Issue issue, IssueChangeHolder issueChangeHolder, Map<String, Object> commentParams, String body) {
        CommentService.CommentParameters commentParameters;
        String groupLevel = (String)commentParams.get(PARAM_GROUP_LEVEL);
        String roleLevelIdStr = (String)commentParams.get(PARAM_ROLE_LEVEL);
        Visibility visibility = Visibilities.fromGroupAndStrRoleId((String)groupLevel, (String)roleLevelIdStr);
        ApplicationUser user = this.authenticationContext.getUser();
        CommentService.CommentCreateValidationResult validationResult = this.commentService.validateCommentCreate(user, commentParameters = CommentService.CommentParameters.builder().author(user).body(body).commentProperties(this.getCommentPropertiesQuietly(commentParams)).visibility(visibility).issue(issue).build());
        if (validationResult.isValid()) {
            Comment comment = this.commentService.create(user, validationResult, false);
            issueChangeHolder.setComment(comment);
        } else {
            log.error("There was an error creating a comment value: " + validationResult.getErrorCollection().toString());
        }
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        Map commentParams;
        if (fieldValueHolder.containsKey(this.getId()) && StringUtils.isNotBlank((CharSequence)((String)(commentParams = (Map)fieldValueHolder.get(this.getId())).get(this.getId())))) {
            issue.setExternalFieldValue(this.getId(), fieldValueHolder.get(this.getId()));
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        if (originalIssues.size() > 1) {
            for (Object originalIssue1 : originalIssues) {
                String targetRendererType;
                String rendererType;
                Issue originalIssue = (Issue)originalIssue1;
                FieldLayoutItem fieldLayoutItem = null;
                try {
                    fieldLayoutItem = ComponentAccessor.getFieldLayoutManager().getFieldLayout(originalIssue.getProjectObject(), originalIssue.getIssueTypeId()).getFieldLayoutItem(this.getId());
                }
                catch (DataAccessException e) {
                    log.warn(this.getName() + " field was unable to resolve the field layout item for issue " + originalIssue.getId(), (Throwable)e);
                }
                if (this.rendererTypesEqual(rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null, targetRendererType = targetFieldLayoutItem != null ? targetFieldLayoutItem.getRendererType() : null)) continue;
                return new MessagedResult(false, this.getAuthenticationContext().getI18nHelper().getText("renderer.bulk.move.warning"), 1);
            }
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        throw new UnsupportedOperationException("Remove is not done through the system field for comment.");
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return false;
    }

    public boolean hasValue(Issue issue) {
        return false;
    }

    public Map<String, Object> getValueFromParams(Map params) throws FieldValidationException {
        if (params.containsKey(this.getId())) {
            return (Map)params.get(this.getId());
        }
        return null;
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
    }

    public String getValueFromIssue(Issue issue) {
        throw new UnsupportedOperationException("Comment system field does not know how to obtain a comment value given an Issue.");
    }

    public boolean isRenderable() {
        return true;
    }

    private void populateVelocityParams(FieldLayoutItem fieldLayoutItem, Map fieldValuesHolder, Map<String, Object> velocityParams) {
        Map commentParams;
        if (fieldValuesHolder != null && (commentParams = (Map)fieldValuesHolder.get(this.getId())) != null) {
            velocityParams.put(this.getId(), commentParams.get(this.getId()));
        }
        velocityParams.put("rendererParams", new HashMap());
        String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
        velocityParams.put("rendererDescriptor", this.rendererManager.getRendererForType(rendererType).getDescriptor());
        velocityParams.put("groupLevels", this.getGroupLevels());
        velocityParams.put("mentionable", this.mentionService.isUserAbleToMention(this.authenticationContext.getUser()));
        Issue issue = (Issue)velocityParams.get("issue");
        if (issue != null) {
            velocityParams.put("roleLevels", this.getRoleLevels(issue));
        } else {
            Project project;
            BulkWorkflowTransition bulkWorkflowTransition;
            BulkEditBean bulkEditBean;
            Object action = velocityParams.get("action");
            if (action != null && action instanceof BulkWorkflowTransition && (bulkEditBean = (bulkWorkflowTransition = (BulkWorkflowTransition)((Object)action)).getBulkEditBean()) != null && (project = bulkEditBean.getProject()) != null) {
                velocityParams.put("roleLevels", this.getRoleLevels(project));
            }
        }
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        String rendererType = null;
        for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
            if (fieldLayout.isFieldHidden(this.getId())) {
                return "bulk.edit.unavailable.hidden";
            }
            if (StringUtils.isBlank(rendererType)) {
                rendererType = fieldLayout.getRendererTypeForField("comment");
                continue;
            }
            if (rendererType.equals(fieldLayout.getRendererTypeForField("comment"))) continue;
            return "bulk.edit.unavailable.different.renderers";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    private Collection getGroupLevels() {
        List groups;
        if (this.authenticationContext.getUser() == null || !this.commentService.isGroupVisibilityEnabled()) {
            groups = Collections.emptyList();
        } else {
            Collection groupNames = this.groupManager.getGroupNamesForUser(this.authenticationContext.getUser().getName());
            ArrayList userGroups = new ArrayList(groupNames);
            Collections.sort(userGroups);
            groups = userGroups;
        }
        return groups;
    }

    private Collection getRoleLevels(Project project) {
        Collection<Object> roles;
        if (project == null) {
            throw new NullPointerException("project GenericValue was null");
        }
        if (this.commentService.isProjectRoleVisibilityEnabled()) {
            ApplicationUser user = this.authenticationContext.getUser();
            roles = this.projectRoleManager.getProjectRoles(user, project);
        } else {
            roles = Collections.emptyList();
        }
        return roles;
    }

    private Collection getRoleLevels(Issue issue) {
        Collection<Object> roles;
        if (this.commentService.isProjectRoleVisibilityEnabled()) {
            ApplicationUser user = this.authenticationContext.getUser();
            roles = this.projectRoleManager.getProjectRoles(user, issue.getProjectObject());
        } else {
            roles = Collections.emptyList();
        }
        return roles;
    }

    private void populateParamsWithSelectedValue(Map commentParams, Map<String, Object> velocityParams) {
        boolean levelPresent = (Boolean)commentParams.get(PARAM_LEVEL_PRESENT);
        if (!levelPresent) {
            velocityParams.put(PARAM_COMMENT_LEVEL, "default");
        } else if (commentParams.get(PARAM_ROLE_LEVEL) != null) {
            velocityParams.put(PARAM_COMMENT_LEVEL, "role:" + commentParams.get(PARAM_ROLE_LEVEL));
        } else if (commentParams.get(PARAM_GROUP_LEVEL) != null) {
            velocityParams.put(PARAM_COMMENT_LEVEL, "group:" + commentParams.get(PARAM_GROUP_LEVEL));
        }
        if (commentParams.get(PARAM_COMMENT_PROPERTY) != null) {
            velocityParams.put(PARAM_COMMENT_PROPERTY, commentParams.get(PARAM_COMMENT_PROPERTY));
        }
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"comments-page", (String)this.getId());
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new CommentRestFieldOperationsHandler(this.commentManager, this.projectRoleManager, this.authenticationContext.getI18nHelper());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, @Nullable FieldLayoutItem fieldLayoutItem) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String rendererType = fieldLayoutItem == null ? null : fieldLayoutItem.getRendererType();
        StreamingCommentsJsonBean commentsWithPaginationJsonBean = new StreamingCommentsJsonBean(issue, false, rendererType);
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData((Object)commentsWithPaginationJsonBean));
        if (renderedVersionRequired) {
            StreamingCommentsJsonBean renderedBean = new StreamingCommentsJsonBean(issue, true, rendererType);
            fieldJsonRepresentation.setRenderedData(new JsonData((Object)renderedBean));
        }
        if (!errorCollection.hasAnyErrors()) {
            return fieldJsonRepresentation;
        }
        log.warn("Failed to include comments in REST response" + errorCollection.toString());
        return null;
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }

    public void validateCommentProperties(Map<String, Object> properties, ErrorCollection errorCollection) {
        try {
            ImmutableMap<String, JSONObject> commentProperties = CommentSystemField.getCommentPropertiesFromParameters(properties);
            for (Map.Entry property : commentProperties.entrySet()) {
                EntityPropertyService.PropertyInput propertyInput = new EntityPropertyService.PropertyInput(((JSONObject)property.getValue()).toString(), (String)property.getKey());
                errorCollection.addErrorCollection(this.commentPropertyService.validatePropertyInput(propertyInput));
            }
        }
        catch (JSONException e) {
            errorCollection.addErrorMessage(this.i18nFactory.getInstance(this.authenticationContext.getUser()).getText("jira.properties.service.invalid.json", properties.get(PARAM_COMMENT_PROPERTY)));
        }
    }

    private ImmutableMap<String, JSONObject> getCommentPropertiesQuietly(Map<String, Object> commentParams) {
        try {
            return CommentSystemField.getCommentPropertiesFromParameters(commentParams);
        }
        catch (JSONException e) {
            log.error("Comment properties are not valid JSON. The properties should be validated before comment is created.");
            return ImmutableMap.of();
        }
    }

    public static ImmutableMap<String, JSONObject> getCommentPropertiesFromParameters(Map<String, Object> commentParams) throws JSONException {
        String[] array;
        if (commentParams.containsKey(PARAM_COMMENT_PROPERTY) && (array = (String[])commentParams.get(PARAM_COMMENT_PROPERTY)) != null && array.length == 1) {
            JSONArray jsonArray = new JSONArray(array[0]);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                builder.put((Object)object.getString("key"), (Object)object.getJSONObject("value"));
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        Stream<String> stream = this.commentManager.streamComments(this.authenticationContext.getLoggedInUser(), issue).map(comment -> {
            Stream.Builder<String> parts = Stream.builder();
            ApplicationUser author = comment.getAuthorApplicationUser();
            if (author != null && comment.getCreated() != null) {
                parts.add(this.csvDateFormatter.formatDateTime(comment.getCreated()));
                parts.add(author.getUsername());
            }
            parts.add(comment.getBody());
            return parts.build().collect(Collectors.joining(";"));
        });
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), stream);
    }
}

