/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.IssueLongFieldComparator;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.AbstractDurationSystemField;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.statistics.TimeTrackingStatisticsMapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;

public class OriginalEstimateSystemField
extends AbstractDurationSystemField
implements ExportableSystemField {
    public OriginalEstimateSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        super("timeoriginalestimate", "common.concepts.original.estimate", "common.concepts.original.estimate", "DESC", new IssueLongFieldComparator("timeoriginalestimate"), templatingEngine, applicationProperties, authenticationContext);
    }

    public LuceneFieldSorter getSorter() {
        return TimeTrackingStatisticsMapper.TIME_ESTIMATE_ORIG;
    }

    @Override
    public String getHiddenFieldId() {
        return "timetracking";
    }

    @Override
    protected Long getDuration(Issue issue) {
        return issue.getOriginalEstimate();
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        Long duration = this.getDuration(issue);
        if (duration != null) {
            return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), (String)String.valueOf(duration));
        }
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), (String)"");
    }
}

