/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItem;
import com.atlassian.jira.issue.fields.config.FieldConfigItemImpl;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class FieldConfigImpl
implements FieldConfig,
Comparable<FieldConfigImpl> {
    private final Long id;
    private final String name;
    private final String description;
    private final List<FieldConfigItem> configItems;
    private final String fieldId;

    public FieldConfigImpl(Long id, String name, String description, List<FieldConfigItemType> configItemTypes, String fieldId) {
        this.id = id;
        this.name = StringUtils.abbreviate((String)name, (int)254);
        this.description = description;
        this.fieldId = fieldId;
        if (configItemTypes == null) {
            configItemTypes = Collections.emptyList();
        }
        ArrayList<FieldConfigItemImpl> configItems = new ArrayList<FieldConfigItemImpl>(configItemTypes.size());
        for (FieldConfigItemType fieldConfigItemType : configItemTypes) {
            configItems.add(new FieldConfigItemImpl(fieldConfigItemType, this));
        }
        this.configItems = Collections.unmodifiableList(configItems);
    }

    public String getDescription() {
        return this.description;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public CustomField getCustomField() {
        CustomField customField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(this.fieldId);
        if (customField == null) {
            throw new DataAccessException("No custom field for " + this.fieldId + ". This should not happen. Data is likely to be corrupt.");
        }
        return customField;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public List<FieldConfigItem> getConfigItems() {
        return this.configItems;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof FieldConfigImpl && this.equals((FieldConfigImpl)o);
    }

    private boolean equals(@Nonnull FieldConfigImpl other) {
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
    }

    @Override
    public int compareTo(@Nonnull FieldConfigImpl rhs) {
        return new CompareToBuilder().append((Object)this.name, (Object)rhs.name).append((Object)this.id, (Object)rhs.id).toComparison();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }
}

