/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface PrioritySchemeService {
    public ServiceOutcome<FieldConfigScheme> assignProjects(@Nonnull ApplicationUser var1, @Nullable FieldConfigScheme var2, @Nonnull Collection<Project> var3);

    public ServiceOutcome<FieldConfigScheme> assignProject(@Nonnull ApplicationUser var1, @Nullable FieldConfigScheme var2, @Nonnull Project var3);

    public ServiceOutcome<FieldConfigScheme> assignProject(@Nonnull ApplicationUser var1, @Nullable Long var2, @Nonnull Either<Long, String> var3, boolean var4);

    public ServiceOutcome<FieldConfigScheme> unassignProject(@Nonnull ApplicationUser var1, @Nullable Long var2, @Nonnull Either<Long, String> var3);

    public ServiceOutcome<FieldConfigScheme> editScheme(@Nonnull ApplicationUser var1, @Nonnull FieldConfigScheme var2, @Nonnull List<String> var3, String var4);

    public ServiceOutcome<FieldConfigScheme> editScheme(@Nonnull ApplicationUser var1, @Nonnull PrioritySchemeData var2, boolean var3);

    public ServiceResult deleteScheme(@Nonnull ApplicationUser var1, @Nonnull FieldConfigScheme var2);

    public ServiceResult deleteScheme(@Nonnull ApplicationUser var1, @Nonnull Long var2);

    public ServiceOutcome<FieldConfigScheme> createScheme(@Nonnull ApplicationUser var1, @Nonnull PrioritySchemeData var2);

    public ServiceOutcome<FieldConfigScheme> getScheme(@Nonnull ApplicationUser var1, @Nonnull Long var2);

    public ServiceOutcome<Collection<FieldConfigScheme>> getSchemes(@Nonnull ApplicationUser var1);

    public ServiceResult schemeDataValidate(ApplicationUser var1, PrioritySchemeData var2);

    public ServiceOutcome<FieldConfigScheme> getSchemeForProject(@Nonnull ApplicationUser var1, @Nonnull Either<Long, String> var2);

    public List<Project> filterProjectsNotPossibleToAssociate(List<Project> var1);

    public boolean hasAnyNotPossibleToAssociateProject(Collection<Project> var1);

    public static class PrioritySchemeData {
        Long id;
        String name;
        String description;
        List<String> priorityIds;
        String defaultPriorityId;

        public PrioritySchemeData(Long id, String name, String description, List<String> priorityIds, String defaultPriorityId) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.priorityIds = Optional.ofNullable(priorityIds).orElse(new ArrayList());
            this.defaultPriorityId = defaultPriorityId;
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        @Nonnull
        public List<String> getPriorityIds() {
            return this.priorityIds;
        }

        public String getDefaultPriorityId() {
            return this.defaultPriorityId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            Long id;
            String name;
            String description;
            List<String> priorityIds;
            String defaultPriorityId;

            public Builder id(Long id) {
                this.id = id;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder defaultPriorityId(String defaultOptionId) {
                this.defaultPriorityId = defaultOptionId;
                return this;
            }

            public Builder priorityIds(List<String> optionIds) {
                this.priorityIds = Optional.ofNullable(optionIds).orElse(new ArrayList());
                return this;
            }

            public PrioritySchemeData build() {
                return new PrioritySchemeData(this.id, this.name, this.description, this.priorityIds, this.defaultPriorityId);
            }
        }
    }
}

