/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntity;
import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ofbiz.core.entity.GenericValue;

public class FieldLayoutSchemeImpl
extends AbstractGVBean
implements FieldLayoutScheme {
    private Long id;
    private String name;
    private String description;
    private final FieldLayoutManager fieldLayoutManager;
    private volatile Map<String, FieldLayoutSchemeEntity> schemeEntities;
    @ClusterSafe(value="Guards in-memory changes to the GenericValue")
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public FieldLayoutSchemeImpl(FieldLayoutManager fieldLayoutManager, GenericValue genericValue) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.setGenericValue(genericValue);
    }

    @Override
    protected void init() {
        this.lock.writeLock().lock();
        try {
            GenericValue gv = this.getGenericValue();
            if (gv != null) {
                this.id = gv.getLong("id");
                this.name = gv.getString("name");
                this.description = gv.getString("description");
            }
            this.setModified(false);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.lock.writeLock().lock();
        try {
            this.name = name;
            this.updateGV("name", name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.lock.writeLock().lock();
        try {
            this.description = description;
            this.updateGV("description", description);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void store() {
        this.lock.writeLock().lock();
        try {
            if (this.getGenericValue() == null) {
                this.fieldLayoutManager.createFieldLayoutScheme((FieldLayoutScheme)this);
            } else {
                this.fieldLayoutManager.updateFieldLayoutScheme((FieldLayoutScheme)this);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getFieldLayoutId(String issueTypeId) {
        this.lock.writeLock().lock();
        try {
            FieldLayoutSchemeEntity fieldLayoutSchemeEntity = this.getInternalSchemeEntities().get(issueTypeId);
            if (fieldLayoutSchemeEntity == null) {
                fieldLayoutSchemeEntity = this.getInternalSchemeEntities().get(null);
            }
            Long l = fieldLayoutSchemeEntity.getFieldLayoutId();
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public FieldLayoutSchemeEntity getEntity(String issueTypeId) {
        return this.getInternalSchemeEntities().get(issueTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldLayoutSchemeEntity getEntity(EditableFieldLayout editableFieldLayout) {
        Collection<FieldLayoutSchemeEntity> values = this.getInternalSchemeEntities().values();
        this.lock.readLock().lock();
        try {
            for (FieldLayoutSchemeEntity fieldLayoutSchemeEntity : values) {
                if (editableFieldLayout.getType() == null) {
                    if (!editableFieldLayout.getId().equals(fieldLayoutSchemeEntity.getFieldLayoutId())) continue;
                    FieldLayoutSchemeEntity fieldLayoutSchemeEntity2 = fieldLayoutSchemeEntity;
                    return fieldLayoutSchemeEntity2;
                }
                if (fieldLayoutSchemeEntity.getFieldLayoutId() != null) continue;
                FieldLayoutSchemeEntity fieldLayoutSchemeEntity3 = fieldLayoutSchemeEntity;
                return fieldLayoutSchemeEntity3;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    public Collection<GenericValue> getProjects() {
        return this.fieldLayoutManager.getProjects((FieldLayoutScheme)this);
    }

    public Collection<Project> getProjectsUsing() {
        return this.fieldLayoutManager.getProjectsUsing((FieldLayoutScheme)this);
    }

    public boolean containsEntity(String issueTypeId) {
        return this.getInternalSchemeEntities().containsKey(issueTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FieldLayoutSchemeEntity> getInternalSchemeEntities() {
        this.lock.readLock().lock();
        try {
            if (this.schemeEntities != null) {
                Map<String, FieldLayoutSchemeEntity> map = this.schemeEntities;
                return map;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.schemeEntities == null) {
                this.schemeEntities = new HashMap<String, FieldLayoutSchemeEntity>();
                Collection fieldLayoutSchemeEntities = this.fieldLayoutManager.getFieldLayoutSchemeEntities((FieldLayoutScheme)this);
                for (FieldLayoutSchemeEntity fieldLayoutSchemeEntity : fieldLayoutSchemeEntities) {
                    this.recordEntity(fieldLayoutSchemeEntity, this.schemeEntities);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.schemeEntities;
    }

    public void addEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        this.lock.writeLock().lock();
        try {
            this.fieldLayoutManager.createFieldLayoutSchemeEntity((FieldLayoutScheme)this, fieldLayoutSchemeEntity.getIssueTypeId(), fieldLayoutSchemeEntity.getFieldLayoutId());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeEntity(String issueTypeId) {
        this.lock.writeLock().lock();
        try {
            if (this.containsEntity(issueTypeId)) {
                this.fieldLayoutManager.removeFieldLayoutSchemeEntity(this.getInternalSchemeEntities().get(issueTypeId));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Collection<FieldLayoutSchemeEntity> getEntities() {
        LinkedList<FieldLayoutSchemeEntity> entities = new LinkedList<FieldLayoutSchemeEntity>(this.getInternalSchemeEntities().values());
        Collections.sort(entities);
        return Collections.unmodifiableCollection(entities);
    }

    public void remove() {
        if (this.getGenericValue() != null) {
            this.lock.writeLock().lock();
            try {
                this.fieldLayoutManager.removeFieldLayoutScheme((FieldLayoutScheme)this);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected void cacheEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        this.recordEntity(fieldLayoutSchemeEntity, this.getInternalSchemeEntities());
    }

    protected void flushEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        this.getInternalSchemeEntities().remove(fieldLayoutSchemeEntity.getIssueTypeId());
    }

    private void recordEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity, Map<String, FieldLayoutSchemeEntity> entities) {
        String issueTypeId = fieldLayoutSchemeEntity.getIssueTypeId();
        entities.put(issueTypeId, fieldLayoutSchemeEntity);
    }
}

