/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.embedded;

import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.issue.fields.renderer.wiki.embedded.ConditionalEmbeddedRenderer;
import com.atlassian.jira.issue.fields.renderer.wiki.embedded.JiraEmbeddedImageRenderer;
import com.atlassian.jira.issue.fields.renderer.wiki.embedded.JiraPlaceholderImageRenderer;
import com.atlassian.jira.issue.fields.renderer.wiki.embedded.JiraTemporaryAttachmentRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachmentManager;
import com.atlassian.renderer.embedded.DefaultEmbeddedResourceRenderer;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class JiraEmbeddedResourceRenderer
extends DefaultEmbeddedResourceRenderer {
    private List<ConditionalEmbeddedRenderer> conditionalRenderers;

    public JiraEmbeddedResourceRenderer(RendererAttachmentManager attachmentManager, TemporaryWebAttachmentManager temporaryWebAttachmentManager) {
        super(attachmentManager);
        this.conditionalRenderers = this.getDefaultConditionalRenderers(attachmentManager, temporaryWebAttachmentManager);
    }

    private ImmutableList<ConditionalEmbeddedRenderer> getDefaultConditionalRenderers(RendererAttachmentManager attachmentManager, TemporaryWebAttachmentManager temporaryWebAttachmentManager) {
        return ImmutableList.of((Object)new JiraTemporaryAttachmentRenderer(attachmentManager, temporaryWebAttachmentManager), (Object)new JiraPlaceholderImageRenderer(attachmentManager));
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        String rendered = this.renderByConditionalRenderers(resource, context);
        if (rendered != null) {
            return rendered;
        }
        return super.renderResource(resource, context);
    }

    private String renderByConditionalRenderers(EmbeddedResource resource, RenderContext context) {
        for (ConditionalEmbeddedRenderer renderer : this.conditionalRenderers) {
            String rendered;
            if (!renderer.shouldRenderResource(resource, context) || !Objects.nonNull(rendered = renderer.renderResource(resource, context))) continue;
            return rendered;
        }
        return null;
    }

    public List<ConditionalEmbeddedRenderer> getConditionalRenderers() {
        return this.conditionalRenderers;
    }

    public void setConditionalRenderers(List<ConditionalEmbeddedRenderer> conditionalRenderers) {
        if (Objects.nonNull(conditionalRenderers)) {
            this.conditionalRenderers = ImmutableList.copyOf(conditionalRenderers);
        }
    }

    protected HashMap getRenderMap() {
        if (this.renderMap == null) {
            this.renderMap = super.getRenderMap();
            this.renderMap.put(EmbeddedImage.class, new JiraEmbeddedImageRenderer(this.attachmentManager));
        }
        return this.renderMap;
    }
}

