/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.jira.issue.index.IssueDocumentFactory;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.log.RateLimitingLogger;
import com.atlassian.util.profiling.Ticker;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;

public class DefaultIssueDocumentFactory
implements IssueDocumentFactory {
    private static final RateLimitingLogger LOG = new RateLimitingLogger(DefaultIssueDocumentFactory.class);
    private final ComponentReference<FieldIndexerManager> fieldIndexerManagerRef = ComponentAccessor.getComponentReference(FieldIndexerManager.class);
    private final SearchExtractorRegistrationManager searchExtractorManager;

    public DefaultIssueDocumentFactory(@Nonnull SearchExtractorRegistrationManager searchExtractorManager) {
        this.searchExtractorManager = (SearchExtractorRegistrationManager)Preconditions.checkNotNull((Object)searchExtractorManager, (Object)"searchExtractorManager");
    }

    public Option<Document> apply(Issue issueObject) {
        LOG.debug("Indexing issue: {}", issueObject.getKey());
        try (Ticker ignored = IndexingTimers.DOC_CREATION_ISSUE.start(new String[0]);){
            Option<Document> option = ((Builder)new Builder(issueObject).addAll(((FieldIndexerManager)this.fieldIndexerManagerRef.get()).getAllIssueIndexers()).addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(Issue.class))).build();
            return option;
        }
    }

    @Override
    public Term getIdentifyingTerm(Issue issue) {
        return new Term("issue_id", issue.getId().toString());
    }

    @Override
    public Term getIdentifyingTerm(Project project) {
        return new Term("projid", project.getId().toString());
    }

    static class Builder
    extends EntityDocumentFactory.EntityDocumentBuilder<Issue, Builder> {
        private final List<String> visibleDocumentFieldIds = Lists.newLinkedList();
        private final Issue issue;
        private Set<String> droppedFields;

        private Builder(Issue issue) {
            super(issue, "issues");
            this.issue = issue;
        }

        Builder addAll(Collection<? extends FieldIndexer> indexers) {
            try (Ticker ignored = IndexingTimers.FIELD_INDEXERS.start(new String[0]);){
                for (FieldIndexer fieldIndexer : indexers) {
                    this.add(fieldIndexer);
                }
                Builder builder = this;
                return builder;
            }
        }

        void add(FieldIndexer indexer) {
            String documentFieldId = null;
            try {
                documentFieldId = indexer.getDocumentFieldId();
                indexer.addIndex(this.doc, this.issue);
                if (indexer.isFieldVisibleAndInScope(this.issue)) {
                    this.visibleDocumentFieldIds.add(documentFieldId);
                }
            }
            catch (RuntimeException re) {
                this.dropField(documentFieldId, indexer, re);
            }
            catch (LinkageError err) {
                this.dropField(documentFieldId, indexer, err);
            }
        }

        @Override
        protected void fieldsAddedByExtractor(Set<String> fieldIds) {
            this.visibleDocumentFieldIds.addAll(fieldIds);
        }

        @Override
        public Option<Document> build() {
            if (this.droppedFields != null) {
                LOG.warn("Error indexing issue " + this.issue.getKey() + ": Dropped: " + this.droppedFields);
            }
            this.generateNonEmptyFieldIds();
            for (String documentFieldId : this.visibleDocumentFieldIds) {
                this.addSearchableField("visiblefieldids", documentFieldId, Field.Store.NO);
            }
            return super.build();
        }

        @Override
        protected String getDocumentType() {
            return "issue";
        }

        private void dropField(String documentFieldId, FieldIndexer indexer, Throwable e) {
            String description = documentFieldId != null ? documentFieldId : indexer.getClass().getName();
            LOG.warn("Error indexing issue " + this.issue.getKey() + ": Dropping '" + description + '\'', e);
            if (this.droppedFields == null) {
                this.droppedFields = Sets.newTreeSet();
            }
            this.droppedFields.add(description);
        }

        private void generateNonEmptyFieldIds() {
            for (String fieldName : this.getNonEmptyFieldNames()) {
                this.addSearchableField("nonemptyfieldids", fieldName, Field.Store.NO);
            }
        }

        private List<String> getNonEmptyFieldNames() {
            List fields = this.doc.getFields();
            ArrayList<String> names = new ArrayList<String>(fields.size());
            for (IndexableField field : fields) {
                if (field.fieldType().indexOptions() == IndexOptions.NONE && field.fieldType().pointDimensionCount() <= 0) continue;
                names.add(field.name());
            }
            return names;
        }
    }
}

