/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.DefaultConfiguration;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.issue.index.IndexingMode;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.lucene.store.Directory;

public interface IndexDirectoryFactory
extends Supplier<Map<Name, Index.Manager>> {
    public String getIndexRootPath();

    public List<String> getIndexPaths();

    public void setIndexingMode(@Nonnull IndexingMode var1);

    public static class IndexPathAdapter
    implements IndexDirectoryFactory {
        private final IndexPathManager indexPathManager;
        private final IndexWriterConfiguration writerConfiguration;
        private final ApplicationProperties applicationProperties;
        private volatile IndexingMode strategy = IndexingMode.QUEUED;

        public IndexPathAdapter(@Nonnull IndexPathManager indexPathManager, IndexWriterConfiguration writerConfiguration, ApplicationProperties applicationProperties) {
            this.applicationProperties = applicationProperties;
            this.indexPathManager = (IndexPathManager)Assertions.notNull((String)"indexPathManager", (Object)indexPathManager);
            this.writerConfiguration = (IndexWriterConfiguration)Assertions.notNull((String)"writerConfiguration", (Object)writerConfiguration);
        }

        public Map<Name, Index.Manager> get() {
            IndexingMode strategy = this.strategy;
            EnumMap<Name, Index.Manager> indexes = new EnumMap<Name, Index.Manager>(Name.class);
            for (Name type : Name.values()) {
                indexes.put(type, strategy.createIndexManager(type.name(), new DefaultConfiguration(type.directory(this.indexPathManager), IssueIndexer.Analyzers.INDEXING, this.writerConfiguration), this.applicationProperties));
            }
            return Collections.unmodifiableMap(indexes);
        }

        @Override
        public String getIndexRootPath() {
            return this.indexPathManager.getIndexRootPath();
        }

        @Override
        public List<String> getIndexPaths() {
            ArrayList<String> result = new ArrayList<String>(Name.values().length);
            for (Name indexType : Name.values()) {
                try {
                    result.add(indexType.getPath(this.indexPathManager));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public void setIndexingMode(@Nonnull IndexingMode strategy) {
            this.strategy = strategy;
        }
    }

    public static enum Name {
        COMMENT{

            @Override
            @Nonnull
            String getPath(@Nonnull IndexPathManager indexPathManager) {
                return indexPathManager.getCommentIndexPath();
            }
        }
        ,
        ISSUE{

            @Override
            @Nonnull
            String getPath(@Nonnull IndexPathManager indexPathManager) {
                return indexPathManager.getIssueIndexPath();
            }
        }
        ,
        CHANGE_HISTORY{

            @Override
            @Nonnull
            String getPath(@Nonnull IndexPathManager indexPathManager) {
                return indexPathManager.getChangeHistoryIndexPath();
            }
        }
        ,
        WORKLOG{

            @Override
            @Nonnull
            String getPath(@Nonnull IndexPathManager indexPathManager) {
                return indexPathManager.getWorklogIndexPath();
            }
        };


        @Nonnull
        final Directory directory(@Nonnull IndexPathManager indexPathManager) {
            LuceneDirectoryUtils luceneDirectoryUtils = (LuceneDirectoryUtils)ComponentAccessor.getComponent(LuceneDirectoryUtils.class);
            return luceneDirectoryUtils.getDirectory(new File(this.getPath(indexPathManager)));
        }

        @Nonnull
        abstract String getPath(@Nonnull IndexPathManager var1);
    }
}

