/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.google.common.base.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;

public class EnglishAnalyzer
extends TextAnalyzer {
    private final Function<TokenStream, TokenStream> stemmingAlgorithm;
    private final Function<TokenStream, TokenStream> stopWordFilter;

    public EnglishAnalyzer(boolean indexing, Function<TokenStream, TokenStream> stemmingStrategy, Function<TokenStream, TokenStream> stopWordFilter) {
        super(indexing);
        this.stemmingAlgorithm = stemmingStrategy;
        this.stopWordFilter = stopWordFilter;
    }

    @Override
    public final Analyzer.TokenStreamComponents createComponents(String fieldName) {
        ClassicTokenizer tokenizer;
        ClassicTokenizer result = tokenizer = new ClassicTokenizer();
        result = new StandardFilter((TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = (TokenStream)this.stopWordFilter.apply((Object)result);
        result = this.wrapStreamForWilcardSearchSupport((TokenStream)result);
        result = (TokenStream)this.stemmingAlgorithm.apply((Object)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }
}

