/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelComparator;
import com.atlassian.jira.issue.label.LabelStore;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizLabelStore
implements LabelStore {
    private static final Logger log = LoggerFactory.getLogger(OfBizLabelStore.class);
    public static final String TABLE = "Label";
    private final OfBizDelegator ofBizDelegator;

    public OfBizLabelStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Set<Label> getLabels(Long issueId, Long customFieldId) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        List labelGvs = this.ofBizDelegator.findByAnd(TABLE, MapBuilder.newBuilder().add((Object)"issue", (Object)issueId).add((Object)"fieldid", (Object)customFieldId).toMap());
        return this.getSortedLabelSet(labelGvs);
    }

    @Override
    public Set<Label> setLabels(Long issueId, Long customFieldId, Set<String> labels) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"labels", labels);
        this.ofBizDelegator.removeByAnd(TABLE, MapBuilder.newBuilder().add((Object)"issue", (Object)issueId).add((Object)"fieldid", (Object)customFieldId).toMap());
        ArrayList<GenericValue> createdGvs = new ArrayList<GenericValue>();
        for (String label : labels) {
            if (StringUtils.isNotBlank((CharSequence)label)) {
                createdGvs.add(this.ofBizDelegator.createValue(TABLE, MapBuilder.newBuilder().add((Object)"issue", (Object)issueId).add((Object)"fieldid", (Object)customFieldId).add((Object)"label", (Object)StringUtils.trim((String)label)).toMap()));
                continue;
            }
            log.error("Blank label cannot be stored!");
        }
        return this.getSortedLabelSet(createdGvs);
    }

    @Override
    public Label addLabel(Long issueId, Long customFieldId, String label) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"label", (Object)label);
        List values = this.ofBizDelegator.findByAnd(TABLE, MapBuilder.newBuilder().add((Object)"issue", (Object)issueId).add((Object)"fieldid", (Object)customFieldId).add((Object)"label", (Object)StringUtils.trim((String)label)).toMap());
        if (values.size() == 1) {
            return new GenericValueToLabel().apply((GenericValue)values.get(0));
        }
        GenericValue value = this.ofBizDelegator.createValue(TABLE, MapBuilder.newBuilder().add((Object)"issue", (Object)issueId).add((Object)"fieldid", (Object)customFieldId).add((Object)"label", (Object)StringUtils.trim((String)label)).toMap());
        return new GenericValueToLabel().apply(value);
    }

    @Override
    public void removeLabel(Long labelId, Long issueId, Long customFieldId) {
        Assertions.notNull((String)"labelId", (Object)labelId);
        this.ofBizDelegator.removeByAnd(TABLE, MapBuilder.newBuilder().add((Object)"id", (Object)labelId).toMap());
    }

    @Override
    public Set<Long> removeLabelsForCustomField(Long customFieldId) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        HashSet<Long> issueIdsAffected = new HashSet<Long>();
        List values = this.ofBizDelegator.findByAnd(TABLE, MapBuilder.newBuilder().add((Object)"fieldid", (Object)customFieldId).toMap());
        for (GenericValue value : values) {
            issueIdsAffected.add(value.getLong("issue"));
        }
        this.ofBizDelegator.removeByAnd(TABLE, MapBuilder.newBuilder().add((Object)"fieldid", (Object)customFieldId).toMap());
        return issueIdsAffected;
    }

    private Set<Label> getSortedLabelSet(List<GenericValue> labelGvs) {
        TreeSet labels = new TreeSet(LabelComparator.INSTANCE);
        labels.addAll(CollectionUtil.transform(labelGvs, (Function)new GenericValueToLabel()));
        return Collections.unmodifiableSet(labels);
    }

    static class GenericValueToLabel
    implements Function<GenericValue, Label> {
        GenericValueToLabel() {
        }

        public Label apply(GenericValue input) {
            return new Label(input.getLong("id"), input.getLong("issue"), input.getLong("fieldid"), input.getString("label"));
        }
    }

    public static final class Columns {
        public static final String ID = "id";
        public static final String CUSTOM_FIELD_ID = "fieldid";
        public static final String ISSUE_ID = "issue";
        public static final String LABEL = "label";
    }
}

