/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.IssuesArchivedEvent;
import com.atlassian.jira.event.issue.IssuesPreArchiveEvent;
import com.atlassian.jira.event.issue.IssuesRestoredEvent;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.ArchiveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.archiving.ArchivedIssueAnalyticEvent;
import com.atlassian.jira.issue.archiving.RestoredIssueAnalyticEvent;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.managers.IssueArchiveHelper;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.project.archiving.ArchivedStatistics;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIssueArchiveHelper
implements IssueArchiveHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueArchiveHelper.class);
    private final IssueManager issueManager;
    private final IssueUpdater issueUpdater;
    private final IssueIndexingService issueIndexingService;
    private final ArchivedStatistics archivedStatistics;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private final IssueEventManager issueEventManager;
    private final IssueEventBundleFactory issueEventBundleFactory;
    private final EventPublisher eventPublisher;
    private final SubTaskManager subTaskManager;
    public static final String ARCHIVED_CHANGEITEM = "Archived";
    public static final String RESTORED_CHANGEITEM = "Restored";

    public DefaultIssueArchiveHelper(IssueManager issueManager, IssueUpdater issueUpdater, IssueIndexingService issueIndexingService, ArchivedStatistics archivedStatistics, ArchivingLicenseCheck archivingLicenseCheck, SubTaskManager subTaskManager, IssueEventManager issueEventManager, IssueEventBundleFactory issueEventBundleFactory, EventPublisher eventPublisher) {
        this.issueManager = issueManager;
        this.issueUpdater = issueUpdater;
        this.issueIndexingService = issueIndexingService;
        this.archivedStatistics = archivedStatistics;
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.subTaskManager = subTaskManager;
        this.issueEventManager = issueEventManager;
        this.issueEventBundleFactory = issueEventBundleFactory;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Issue archiveIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws ArchiveException {
        if (!this.isArchivingAllowed()) {
            throw new ArchiveException("admin.errors.archivedissue.error.feature.not.active");
        }
        Transaction transaction = Txn.begin();
        try {
            for (Issue issueObject : issue.getSubTaskObjects()) {
                this.update(user, issueObject, eventDispatchOption, sendMail, true);
            }
            Issue archivedIssue = this.update(user, issue, eventDispatchOption, sendMail, true);
            transaction.commit();
            Issue issue2 = archivedIssue;
            return issue2;
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    private Issue update(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail, boolean archive) throws ArchiveException {
        GenericValue genericIssue = (GenericValue)issue.getGenericValue().clone();
        if (genericIssue == null) {
            throw new IllegalArgumentException("The provided issue has a null GenericValue.");
        }
        if (eventDispatchOption.isEventBeingSent()) {
            this.dispatchPreArchiveEvent(eventDispatchOption, issue);
        }
        genericIssue.set("archived", (Object)archive);
        genericIssue.set("archivedby", (Object)(archive ? user.getKey() : null));
        genericIssue.set("archiveddate", (Object)(archive ? UtilDateTime.nowTimestamp() : null));
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(genericIssue, issue.getGenericValue(), eventDispatchOption.getEventTypeId(), user, sendMail, false);
        issueUpdateBean.setDispatchEvent(false);
        issueUpdateBean.setChangeItems(this.generateChangeItem(archive));
        this.issueUpdater.doUpdate(issueUpdateBean, false, false);
        if (!issue.isSubTask()) {
            this.issueEventManager.dispatchEvent(this.issueEventBundleFactory.createIssueArchivingRelatedEventBundle(issue, issueUpdateBean, user));
        }
        MutableIssue updatedIssue = this.issueManager.getIssueObject(issue.getId());
        Long projectId = updatedIssue.getProjectId();
        ProjectTypeKey projectTypeKey = updatedIssue.getProjectObject().getProjectTypeKey();
        if (archive) {
            this.eventPublisher.publish((Object)new ArchivedIssueAnalyticEvent(updatedIssue.getId(), projectId, projectTypeKey.getKey()));
            this.eventPublisher.publish((Object)new IssuesArchivedEvent(updatedIssue.getId()));
            return this.deindex((Issue)updatedIssue);
        }
        this.eventPublisher.publish((Object)new RestoredIssueAnalyticEvent(updatedIssue.getId(), projectId, projectTypeKey.getKey()));
        this.eventPublisher.publish((Object)new IssuesRestoredEvent(updatedIssue.getId()));
        return this.reindex((Issue)updatedIssue);
    }

    private Issue deindex(Issue updatedIssue) throws ArchiveException {
        try {
            this.issueIndexingService.deIndex(updatedIssue);
        }
        catch (IndexException e) {
            log.error("Deindexing issue failed: ", (Throwable)e);
            throw new ArchiveException("admin.errors.archivedissue.error.cant.deindex.issue");
        }
        finally {
            this.archivedStatistics.invalidate();
        }
        return updatedIssue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Issue restoreIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws ArchiveException {
        if (!this.isArchivingAllowed()) {
            throw new ArchiveException("admin.errors.archivedissue.error.feature.not.active");
        }
        Transaction transaction = Txn.begin();
        try {
            for (Issue issueObject : issue.getSubTaskObjects()) {
                this.update(user, issueObject, eventDispatchOption, sendMail, false);
            }
            Issue restoredIssue = this.update(user, issue, eventDispatchOption, sendMail, false);
            transaction.commit();
            Issue issue2 = restoredIssue;
            return issue2;
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    private Issue reindex(Issue updatedIssue) throws ArchiveException {
        try {
            this.issueIndexingService.reIndex(updatedIssue);
        }
        catch (IndexException e) {
            log.error("Indexing issue failed: ", (Throwable)e);
            throw new ArchiveException("admin.errors.archivedissue.error.cant.index.issue");
        }
        finally {
            this.archivedStatistics.invalidate();
        }
        return updatedIssue;
    }

    private Collection<ChangeItemBean> generateChangeItem(boolean archived) {
        ChangeItemBean changeItemBean = archived ? new ChangeItemBean("custom", ARCHIVED_CHANGEITEM, "", "", "", "Issue archived") : new ChangeItemBean("custom", RESTORED_CHANGEITEM, "", "", "", "Issue restored");
        return ImmutableList.of((Object)changeItemBean);
    }

    protected boolean isArchivingAllowed() {
        return this.archivingLicenseCheck.isLicensedForIssueArchiving();
    }

    private void dispatchPreArchiveEvent(EventDispatchOption eventDispatchOption, Issue issue) {
        if (eventDispatchOption.isEventBeingSent()) {
            this.eventPublisher.publish((Object)new IssuesPreArchiveEvent(issue.getId()));
        }
    }
}

