/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.priority;

import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.project.Project;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PrioritySchemeMapping {
    private final Collection<Project> affectedProjects = new HashSet<Project>();
    private final Map<Long, Map<Priority, Priority>> schemeIdToPriorityMapping = new HashMap<Long, Map<Priority, Priority>>();
    private final FieldConfigScheme targetScheme;

    public PrioritySchemeMapping(FieldConfigScheme targetScheme) {
        this.targetScheme = targetScheme;
    }

    public Map<Priority, Priority> getPriorityMappingForProject(PrioritySchemeManager prioritySchemeManager, Project project) {
        FieldConfigScheme fieldConfigScheme = prioritySchemeManager.getScheme(project);
        return this.mappingForScheme(fieldConfigScheme);
    }

    public Map<Priority, Priority> mappingForScheme(FieldConfigScheme scheme) {
        if (this.schemeIdToPriorityMapping.containsKey(scheme.getId())) {
            return ImmutableMap.copyOf(this.schemeIdToPriorityMapping.get(scheme.getId()));
        }
        return ImmutableMap.of();
    }

    public void addPriorityMapping(long prioritySchemeId, Priority from, Priority to) {
        this.schemeIdToPriorityMapping.putIfAbsent(prioritySchemeId, new HashMap());
        Map<Priority, Priority> priorityMappingForScheme = this.schemeIdToPriorityMapping.get(prioritySchemeId);
        priorityMappingForScheme.put(from, to);
    }

    public boolean isEmpty() {
        return this.schemeIdToPriorityMapping.isEmpty();
    }

    public Collection<Project> getAffectedProjects() {
        return this.affectedProjects;
    }

    public void addAffectedProjects(Collection<Project> affectedProjects) {
        this.affectedProjects.addAll(affectedProjects);
    }

    public FieldConfigScheme getTargetScheme() {
        return this.targetScheme;
    }
}

