/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchContextImpl
implements SearchContext {
    private static final List<Long> ALL_PROJECTS = Collections.singletonList(null);
    private static final List<String> ALL_ISSUE_TYPES = Collections.singletonList(null);
    private static final Logger log = LoggerFactory.getLogger(SearchContextImpl.class);
    private static final Predicate LONG_PREDICATE = new AndPredicate(InstanceofPredicate.getInstance(Long.class), ObjectUtils.getIsSetPredicate());
    private static final Predicate STRING_PREDICATE = new AndPredicate(InstanceofPredicate.getInstance(String.class), ObjectUtils.getIsSetPredicate());
    @Nonnull
    private final List<Long> projectCategoryIds;
    @Nonnull
    private final List<Long> projectIds;
    @Nonnull
    private final List<String> issueTypeIds;
    private List<Project> projects;
    private List<IssueType> issueTypes;
    private final ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
    private final ProjectManager projectManager = ComponentAccessor.getProjectManager();

    public SearchContextImpl() {
        this(null, null, null);
    }

    public SearchContextImpl(List<Long> projectCategoryIds, List<Long> projectIds, List<String> issueTypeIds) {
        this.projectCategoryIds = SearchContextImpl.prepareProjectList(projectCategoryIds);
        this.projectIds = SearchContextImpl.prepareProjectList(projectIds);
        this.issueTypeIds = ListUtils.predicatedList((List)this.constantsManager.expandIssueTypeIds(issueTypeIds), (Predicate)STRING_PREDICATE);
    }

    public SearchContextImpl(SearchContext searchContext) {
        this(searchContext.getProjectCategoryIds(), searchContext.getProjectIds(), searchContext.getIssueTypeIds());
    }

    public boolean isForAnyProjects() {
        return this.projectCategoryIds.isEmpty() && this.projectIds.isEmpty();
    }

    public boolean isForAnyIssueTypes() {
        return this.issueTypeIds.isEmpty();
    }

    public boolean isSingleProjectContext() {
        return this.projectIds.size() == 1;
    }

    public Project getSingleProject() {
        if (this.isSingleProjectContext()) {
            return this.projectManager.getProjectObj(this.projectIds.get(0));
        }
        throw new IllegalStateException("This is not a single project context");
    }

    @Nonnull
    public List<Long> getProjectCategoryIds() {
        return this.projectCategoryIds;
    }

    @Nonnull
    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    @Nonnull
    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public List<IssueContext> getAsIssueContexts() {
        List<Long> projectIds = this.projectIds.isEmpty() ? ALL_PROJECTS : this.projectIds;
        List<String> issueTypeIds = this.issueTypeIds.isEmpty() ? ALL_ISSUE_TYPES : this.issueTypeIds;
        ArrayList<IssueContext> issueContexts = new ArrayList<IssueContext>(projectIds.size() * issueTypeIds.size());
        projectIds.forEach(projectId -> issueTypeIds.stream().map(issueTypeId -> new IssueContextImpl(projectId, issueTypeId)).forEach(issueContexts::add));
        return issueContexts;
    }

    public void verify() {
        Iterator<Object> iterator = this.projectIds.iterator();
        while (iterator.hasNext()) {
            Long projectId = iterator.next();
            if (this.projectManager.getProjectObj(projectId) != null) continue;
            log.warn("Project id {} found in searchContext but is not valid. Being removed.", (Object)projectId);
            iterator.remove();
        }
        iterator = this.issueTypeIds.iterator();
        while (iterator.hasNext()) {
            String issueTypeId = (String)iterator.next();
            if (this.constantsManager.getIssueType(issueTypeId) != null) continue;
            log.warn("Issue type id {} found in searchContext but is not valid. Being removed.", (Object)issueTypeId);
            iterator.remove();
        }
    }

    @Nonnull
    private static List<Long> prepareProjectList(List<Long> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (list.size() == 1 && !ObjectUtils.isValueSelected((Object)list.get(0))) {
            return Collections.emptyList();
        }
        return ListUtils.predicatedList(list, (Predicate)LONG_PREDICATE);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("projectCategoryIds", this.projectCategoryIds).append("projectIds", this.projectIds).append("issueTypeIds", this.issueTypeIds).toString();
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof SearchContextImpl && this.equals((SearchContextImpl)o);
    }

    private boolean equals(@Nonnull SearchContextImpl rhs) {
        return Objects.equals(this.projectCategoryIds, rhs.projectCategoryIds) && Objects.equals(this.projectIds, rhs.projectIds) && Objects.equals(this.issueTypeIds, rhs.issueTypeIds);
    }

    public int hashCode() {
        return Objects.hash(this.projectCategoryIds, this.projectIds, this.issueTypeIds);
    }

    @Nonnull
    public List<Project> getProjects() {
        if (this.projects == null) {
            this.projects = (List)this.projectIds.stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableListWithSizeOf(this.projectIds));
        }
        return this.projects;
    }

    @Nonnull
    public List<IssueType> getIssueTypes() {
        if (this.issueTypes == null) {
            this.issueTypes = (List)this.issueTypeIds.stream().map(arg_0 -> ((ConstantsManager)this.constantsManager).getIssueType(arg_0)).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableListWithSizeOf(this.issueTypeIds));
        }
        return this.issueTypes;
    }
}

