/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.customfields.converters.DateConverter;
import com.atlassian.jira.issue.customfields.converters.DateTimeConverter;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.DateSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.DateSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import java.util.Collections;

public class AbstractDateSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    private final SearcherInformation<SearchableField> searcherInformation;
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;

    public AbstractDateSearcher(SimpleFieldSearchConstants constants, String nameKey, Class<? extends BaseFieldIndexer> indexer, DateConverter dateConverter, DateTimeConverter dateTimeConverter, JqlDateSupport dateSupport, JqlOperandResolver operandResolver, ApplicationProperties applicationProperties, VelocityRequestContextFactory velocityRenderContext, VelocityTemplatingEngine templatingEngine, CalendarLanguageUtil calendarUtils, FieldVisibilityManager fieldVisibilityManager, CustomFieldInputHelper customFieldInputHelper, TimeZoneManager timeZoneManager, DateTimeFormatterFactory dateTimeFormatterFactory) {
        DateSearcherConfig config = new DateSearcherConfig(constants.getUrlParameter(), constants.getJqlClauseNames(), constants.getJqlClauseNames().getPrimaryName());
        this.searcherInformation = new GenericSearcherInformation(constants.getSearcherId(), nameKey, Collections.singletonList(indexer), this.fieldReference, SearcherGroupType.DATE);
        this.searchInputTransformer = new DateSearchInputTransformer(false, config, dateConverter, dateTimeConverter, operandResolver, dateSupport, customFieldInputHelper, timeZoneManager, dateTimeFormatterFactory);
        this.searchRenderer = new DateSearchRenderer(constants, config, nameKey, velocityRenderContext, applicationProperties, templatingEngine, calendarUtils, fieldVisibilityManager);
    }

    public final SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    public final SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    public final SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

