/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentComparator;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.option.GroupTextOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractProjectConstantsRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.ComponentOptions;
import com.atlassian.jira.issue.search.searchers.renderer.OptionWithValidity;
import com.atlassian.jira.issue.search.searchers.transformer.ComponentSearchInput;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentSearchRenderer
extends AbstractProjectConstantsRenderer<ComponentSearchInput, ComponentOptions> {
    private static final Function<String, AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> MAKE_COMPONENT_LABEL = new Function<String, AbstractProjectConstantsRenderer.GenericProjectConstantsLabel>(){

        public AbstractProjectConstantsRenderer.GenericProjectConstantsLabel apply(String input) {
            return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(input);
        }
    };
    private static final Function<String, Option> NAME_TO_OPTION = new Function<String, Option>(){

        public Option apply(String name) {
            return new OptionWithValidity(AbstractProjectConstantsRenderer.createId(name), name);
        }
    };
    private static final Function<ComponentSearchInput, String> INPUT_OPTION_VALUE = new Function<ComponentSearchInput, String>(){

        public String apply(ComponentSearchInput input) {
            if (input.isComponent()) {
                return AbstractProjectConstantsRenderer.createId(input.getValue());
            }
            if (input.isNoComponent()) {
                return "-1";
            }
            throw new IllegalArgumentException("Invalid input");
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ComponentSearchRenderer.class);
    private final ProjectComponentManager projectComponentManager;

    public ComponentSearchRenderer(ApplicationProperties applicationProperties, FieldVisibilityManager fieldVisibilityManager, ProjectComponentManager projectComponentManager, ProjectManager projectManager, SimpleFieldSearchConstantsWithEmpty searchConstants, String searcherNameKey, VelocityTemplatingEngine templatingEngine, VelocityRequestContextFactory velocityRequestContextFactory, PermissionManager permissionManager) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, fieldVisibilityManager, searchConstants, projectManager, searcherNameKey, permissionManager);
        this.projectComponentManager = projectComponentManager;
    }

    @Override
    ComponentOptions getValidOptions(ApplicationUser searcher, SearchContext searchContext) {
        ComponentOptions componentOptions = new ComponentOptions();
        Collection<Object> componentNames = Collections.emptyList();
        if (searchContext.isSingleProjectContext()) {
            Long projectID = (Long)searchContext.getProjectIds().get(0);
            if (this.isValidProject(projectID, searcher)) {
                componentNames = Sets.newTreeSet((Comparator)ProjectComponentComparator.COMPONENT_NAME_COMPARATOR);
                componentNames.addAll(CollectionUtil.transform((Iterable)this.projectComponentManager.findAllForProject(projectID), (Function)new Function<ProjectComponent, String>(){

                    public String apply(ProjectComponent component) {
                        return component.getName();
                    }
                }));
            } else {
                log.warn("Project " + projectID + " for search context " + searchContext + " is invalid.");
            }
        } else if (CollectionUtils.isEmpty((Collection)searchContext.getProjectIds())) {
            Collection<Project> visibleProjects = this.getVisibleProjects(searcher);
            if (CollectionUtils.isNotEmpty(visibleProjects)) {
                componentNames = this.projectComponentManager.findAllUniqueNamesForProjectObjects(visibleProjects);
            }
        } else {
            ArrayList validProjectIds = Lists.newArrayListWithCapacity((int)searchContext.getProjectIds().size());
            for (Long projectID : searchContext.getProjectIds()) {
                if (this.isValidProject(projectID, searcher)) {
                    validProjectIds.add(projectID);
                    continue;
                }
                log.warn("Project " + projectID + " for search context " + searchContext + " is invalid.");
            }
            if (!validProjectIds.isEmpty()) {
                componentNames = this.projectComponentManager.findAllUniqueNamesForProjects((Collection)validProjectIds);
            }
        }
        List options = CollectionUtil.transform(componentNames, NAME_TO_OPTION);
        componentOptions.options(new GroupTextOption("", "", Lists.newArrayList((Iterable)options)));
        return componentOptions;
    }

    @Override
    Function<ComponentSearchInput, String> inputValueToOptionIdFunction() {
        return INPUT_OPTION_VALUE;
    }

    @Override
    OptionWithValidity createBlankOption(ApplicationUser user) {
        return new OptionWithValidity("-1", this.getI18n(user).getText("common.concepts.nocomponent"));
    }

    @Override
    void createGroups(List<GroupTextOption> groups, ComponentOptions options, Set<Option> invalidOptions) {
        this.addOption(groups, "", Lists.newArrayList((Object[])new Option[]{options.getNo()}));
        this.addOption(groups, options.getOptions());
        this.addOption(groups, "invalid", invalidOptions);
    }

    @Override
    String nameFromSelectedValue(ApplicationUser searcher, ComponentSearchInput searchInput) {
        if (searchInput.isNoComponent()) {
            return this.getI18n(searcher).getText("common.concepts.nocomponent");
        }
        return searchInput.getValue();
    }

    @Override
    Collection<AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> getSelectedLabels(ApplicationUser searcher, Collection<ComponentSearchInput> selectedValues) {
        ArrayList componentNames;
        ArrayList arrayList = componentNames = selectedValues != null ? Lists.newArrayListWithCapacity((int)selectedValues.size()) : Lists.newArrayList();
        if (selectedValues != null) {
            for (ComponentSearchInput selectedValue : selectedValues) {
                componentNames.add(this.nameFromSelectedValue(searcher, selectedValue));
            }
        }
        return this.getSelectedObjects(componentNames, MAKE_COMPONENT_LABEL);
    }
}

