/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.AbstractSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.TextQueryValidatingVisitor;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.Map;

public class TextQuerySearchInputTransformer
extends AbstractSearchInputTransformer {
    private ClauseNames clauseNames;

    public TextQuerySearchInputTransformer(String id, ClauseInformation information, JqlOperandResolver operandResolver) {
        super(operandResolver, id, id);
        this.clauseNames = information.getJqlClauseNames();
    }

    public boolean doRelevantClausesFitFilterForm(ApplicationUser user, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            Clause whereClause = query.getWhereClause();
            TextQueryValidatingVisitor visitor = new TextQueryValidatingVisitor(this.clauseNames.getPrimaryName());
            whereClause.accept((ClauseVisitor)visitor);
            if (visitor.isValid()) {
                String textQuery = visitor.getTextTerminalValue(this.operandResolver, user);
                return textQuery != null;
            }
        }
        return false;
    }

    public void populateFromParams(ApplicationUser user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        fieldValuesHolder.put((Object)this.fieldsKey, (Object)actionParams.getFirstValueForKey(this.id));
    }

    public void populateFromQuery(ApplicationUser user, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            String textQuery;
            Clause whereClause = query.getWhereClause();
            TextQueryValidatingVisitor visitor = new TextQueryValidatingVisitor(this.clauseNames.getPrimaryName());
            whereClause.accept((ClauseVisitor)visitor);
            if (visitor.isValid() && (textQuery = visitor.getTextTerminalValue(this.operandResolver, user)) != null) {
                fieldValuesHolder.put((Object)this.fieldsKey, (Object)textQuery.trim());
            }
        }
    }

    public Clause getSearchClause(ApplicationUser user, FieldValuesHolder fieldValuesHolder) {
        String query = ParameterUtils.getStringParam((Map)fieldValuesHolder, (String)this.fieldsKey);
        if (query != null) {
            return new TerminalClauseImpl(this.clauseNames.getPrimaryName(), Operator.LIKE, query);
        }
        return null;
    }
}

